/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.classification;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.datagenerators.ClassificationGenerator;
import weka.datagenerators.Test;

public class RDG1
extends ClassificationGenerator {
    static final long serialVersionUID = 7751005204635320414L;
    protected int m_NumAttributes;
    protected int m_NumClasses;
    private int m_MaxRuleSize;
    private int m_MinRuleSize;
    private int m_NumIrrelevant;
    private int m_NumNumeric;
    private boolean m_VoteFlag = false;
    private FastVector m_DecisionList = null;
    boolean[] m_AttList_Irr;

    public RDG1() {
        this.setNumAttributes(this.defaultNumAttributes());
        this.setNumClasses(this.defaultNumClasses());
        this.setMaxRuleSize(this.defaultMaxRuleSize());
        this.setMinRuleSize(this.defaultMinRuleSize());
        this.setNumIrrelevant(this.defaultNumIrrelevant());
        this.setNumNumeric(this.defaultNumNumeric());
    }

    public String globalInfo() {
        return "A data generator that produces data randomly by producing a decision list.\nThe decision list consists of rules.\nInstances are generated randomly one by one. If decision list fails to classify the current instance, a new rule according to this current instance is generated and added to the decision list.\n\nThe option -V switches on voting, which means that at the end of the generation all instances are reclassified to the class value that is supported by the most rules.\n\nThis data generator can generate 'boolean' attributes (= nominal with the values {true, false}) and numeric attributes. The rules can be 'A' or 'NOT A' for boolean values and 'B < random_value' or 'B >= random_value' for numeric values.";
    }

    public Enumeration listOptions() {
        Vector vector = this.enumToVector(super.listOptions());
        vector.addElement(new Option("\tThe number of attributes (default " + this.defaultNumAttributes() + ").", "a", 1, "-a <num>"));
        vector.addElement(new Option("\tThe number of classes (default " + this.defaultNumClasses() + ")", "c", 1, "-c <num>"));
        vector.addElement(new Option("\tmaximum size for rules (default " + this.defaultMaxRuleSize() + ") ", "R", 1, "-R <num>"));
        vector.addElement(new Option("\tminimum size for rules (default " + this.defaultMinRuleSize() + ") ", "M", 1, "-M <num>"));
        vector.addElement(new Option("\tnumber of irrelevant attributes (default " + this.defaultNumIrrelevant() + ")", "I", 1, "-I <num>"));
        vector.addElement(new Option("\tnumber of numeric attributes (default " + this.defaultNumNumeric() + ")", "N", 1, "-N"));
        vector.addElement(new Option("\tswitch on voting (default is no voting)", "V", 1, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('a', stringArray);
        if (string.length() != 0) {
            this.setNumAttributes(Integer.parseInt(string));
        } else {
            this.setNumAttributes(this.defaultNumAttributes());
        }
        string = Utils.getOption('c', stringArray);
        if (string.length() != 0) {
            this.setNumClasses(Integer.parseInt(string));
        } else {
            this.setNumClasses(this.defaultNumClasses());
        }
        string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setMaxRuleSize(Integer.parseInt(string));
        } else {
            this.setMaxRuleSize(this.defaultMaxRuleSize());
        }
        string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMinRuleSize(Integer.parseInt(string));
        } else {
            this.setMinRuleSize(this.defaultMinRuleSize());
        }
        string = Utils.getOption('I', stringArray);
        if (string.length() != 0) {
            this.setNumIrrelevant(Integer.parseInt(string));
        } else {
            this.setNumIrrelevant(this.defaultNumIrrelevant());
        }
        if (this.getNumAttributes() - this.getNumIrrelevant() < this.getMinRuleSize()) {
            throw new Exception("Possible rule size is below minimal rule size.");
        }
        string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNumNumeric(Integer.parseInt(string));
        } else {
            this.setNumNumeric(this.defaultNumNumeric());
        }
        this.setVoteFlag(Utils.getFlag('V', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-a");
        vector.add("" + this.getNumAttributes());
        vector.add("-c");
        vector.add("" + this.getNumClasses());
        vector.add("-N");
        vector.add("" + this.getNumNumeric());
        vector.add("-I");
        vector.add("" + this.getNumIrrelevant());
        vector.add("-M");
        vector.add("" + this.getMinRuleSize());
        vector.add("-R");
        vector.add("" + this.getMaxRuleSize());
        if (this.getVoteFlag()) {
            vector.add("-V");
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected int defaultNumAttributes() {
        return 10;
    }

    public void setNumAttributes(int n) {
        this.m_NumAttributes = n;
    }

    public int getNumAttributes() {
        return this.m_NumAttributes;
    }

    public String numAttributesTipText() {
        return "The number of attributes the generated data will contain.";
    }

    protected int defaultNumClasses() {
        return 2;
    }

    public void setNumClasses(int n) {
        this.m_NumClasses = n;
    }

    public int getNumClasses() {
        return this.m_NumClasses;
    }

    public String numClassesTipText() {
        return "The number of classes to generate.";
    }

    protected int defaultMaxRuleSize() {
        return 10;
    }

    public int getMaxRuleSize() {
        return this.m_MaxRuleSize;
    }

    public void setMaxRuleSize(int n) {
        this.m_MaxRuleSize = n;
    }

    public String maxRuleSizeTipText() {
        return "The maximum number of tests in rules.";
    }

    protected int defaultMinRuleSize() {
        return 1;
    }

    public int getMinRuleSize() {
        return this.m_MinRuleSize;
    }

    public void setMinRuleSize(int n) {
        this.m_MinRuleSize = n;
    }

    public String minRuleSizeTipText() {
        return "The minimum number of tests in rules.";
    }

    protected int defaultNumIrrelevant() {
        return 0;
    }

    public int getNumIrrelevant() {
        return this.m_NumIrrelevant;
    }

    public void setNumIrrelevant(int n) {
        this.m_NumIrrelevant = n;
    }

    public String numIrrelevantTipText() {
        return "The number of irrelevant attributes.";
    }

    protected int defaultNumNumeric() {
        return 0;
    }

    public int getNumNumeric() {
        return this.m_NumNumeric;
    }

    public void setNumNumeric(int n) {
        this.m_NumNumeric = n;
    }

    public String numNumericTipText() {
        return "The number of numerical attributes.";
    }

    public boolean getVoteFlag() {
        return this.m_VoteFlag;
    }

    public void setVoteFlag(boolean bl) {
        this.m_VoteFlag = bl;
    }

    public String voteFlagTipText() {
        return "Whether to use voting or not.";
    }

    public boolean getSingleModeFlag() {
        return !this.getVoteFlag();
    }

    public boolean[] getAttList_Irr() {
        return this.m_AttList_Irr;
    }

    public void setAttList_Irr(boolean[] blArray) {
        this.m_AttList_Irr = blArray;
    }

    public String attList_IrrTipText() {
        return "The array with the indices of the irrelevant attributes.";
    }

    public Instances defineDataFormat() throws Exception {
        Random random = new Random(this.getSeed());
        this.setRandom(random);
        this.m_DecisionList = new FastVector();
        this.setNumExamplesAct(this.getNumExamples());
        Instances instances = this.defineDataset(random);
        return instances;
    }

    public Instance generateExample() throws Exception {
        Random random = this.getRandom();
        Instances instances = this.getDatasetFormat();
        if (instances == null) {
            throw new Exception("Dataset format not defined.");
        }
        if (this.getVoteFlag()) {
            throw new Exception("Examples cannot be generated one by one.");
        }
        instances = this.generateExamples(1, random, instances);
        return instances.lastInstance();
    }

    public Instances generateExamples() throws Exception {
        Random random = this.getRandom();
        Instances instances = this.getDatasetFormat();
        if (instances == null) {
            throw new Exception("Dataset format not defined.");
        }
        instances = this.generateExamples(this.getNumExamplesAct(), random, instances);
        if (this.getVoteFlag()) {
            instances = this.voteDataset(instances);
        }
        return instances;
    }

    public Instances generateExamples(int n, Random random, Instances instances) throws Exception {
        if (instances == null) {
            throw new Exception("Dataset format not defined.");
        }
        for (int i = 0; i < n; ++i) {
            Instance instance = this.generateExample(random, instances);
            boolean bl = this.classifyExample(instance);
            if (!bl) {
                instance = this.updateDecisionList(random, instance);
            }
            instance.setDataset(instances);
            instances.add(instance);
        }
        return instances;
    }

    private Instance updateDecisionList(Random random, Instance instance) throws Exception {
        RevisionHandler revisionHandler;
        Instances instances = this.getDatasetFormat();
        if (instances == null) {
            throw new Exception("Dataset format not defined.");
        }
        FastVector fastVector = this.generateTestList(random, instance);
        int n = this.getMaxRuleSize() < fastVector.size() ? this.getMaxRuleSize() : fastVector.size();
        int n2 = (int)(random.nextDouble() * (double)(n - this.getMinRuleSize())) + this.getMinRuleSize();
        RuleList ruleList = new RuleList();
        for (int i = 0; i < n2; ++i) {
            int n3 = (int)(random.nextDouble() * (double)fastVector.size());
            revisionHandler = (Test)fastVector.elementAt(n3);
            ruleList.addTest((Test)revisionHandler);
            fastVector.removeElementAt(n3);
        }
        double d = 0.0;
        if (this.m_DecisionList.size() > 0) {
            revisionHandler = (RuleList)this.m_DecisionList.lastElement();
            double d2 = ((RuleList)revisionHandler).getClassValue();
            d = (double)((int)d2 + 1) % (double)this.getNumClasses();
        }
        ruleList.setClassValue(d);
        this.m_DecisionList.addElement(ruleList);
        instance = (Instance)instance.copy();
        instance.setDataset(instances);
        instance.setClassValue(d);
        return instance;
    }

    private FastVector generateTestList(Random random, Instance instance) throws Exception {
        Instances instances = this.getDatasetFormat();
        if (instances == null) {
            throw new Exception("Dataset format not defined.");
        }
        int n = this.getNumAttributes() - this.getNumIrrelevant();
        FastVector fastVector = new FastVector(n);
        boolean[] blArray = this.getAttList_Irr();
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            if (blArray[i]) continue;
            Test test = null;
            Attribute attribute = instance.attribute(i);
            if (attribute.isNumeric()) {
                double d = random.nextDouble();
                boolean bl = d < instance.value(i);
                test = new Test(i, d, instances, bl);
            } else {
                test = new Test(i, instance.value(i), instances, false);
            }
            fastVector.addElement(test);
        }
        return fastVector;
    }

    private Instance generateExample(Random random, Instances instances) throws Exception {
        double[] dArray = new double[this.getNumAttributes() + 1];
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            double d = random.nextDouble();
            if (instances.attribute(i).isNumeric()) {
                dArray[i] = d;
                continue;
            }
            if (instances.attribute(i).isNominal()) {
                dArray[i] = d > 0.5 ? 1.0 : 0.0;
                continue;
            }
            throw new Exception("Attribute type is not supported.");
        }
        Instance instance = new Instance(0.0, dArray);
        instance.setDataset(instances);
        instance.setClassMissing();
        return instance;
    }

    private boolean classifyExample(Instance instance) throws Exception {
        double d = -1.0;
        Enumeration enumeration = this.m_DecisionList.elements();
        while (enumeration.hasMoreElements() && d < 0.0) {
            RuleList ruleList = (RuleList)enumeration.nextElement();
            d = ruleList.classifyInstance(instance);
        }
        if (d >= 0.0) {
            instance.setClassValue(d);
            return true;
        }
        return false;
    }

    private Instance votedReclassifyExample(Instance instance) throws Exception {
        int n;
        int[] nArray = new int[this.getNumClasses()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        Enumeration enumeration = this.m_DecisionList.elements();
        while (enumeration.hasMoreElements()) {
            RuleList ruleList = (RuleList)enumeration.nextElement();
            n = (int)ruleList.classifyInstance(instance);
            if (n < 0) continue;
            int n2 = n;
            nArray[n2] = nArray[n2] + 1;
        }
        int n3 = 0;
        int n4 = -1;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] <= n3) continue;
            n3 = nArray[n];
            n4 = n;
        }
        if (n4 < 0) {
            throw new Exception("Error in instance classification.");
        }
        instance.setClassValue(n4);
        return instance;
    }

    private Instances defineDataset(Random random) throws Exception {
        Attribute attribute;
        int n;
        FastVector fastVector = new FastVector();
        FastVector fastVector2 = new FastVector(2);
        fastVector2.addElement("false");
        fastVector2.addElement("true");
        FastVector fastVector3 = new FastVector(this.getNumClasses());
        boolean[] blArray = this.defineIrrelevant(random);
        this.setAttList_Irr(blArray);
        int[] nArray = this.defineNumeric(random);
        for (n = 0; n < this.getNumAttributes(); ++n) {
            attribute = nArray[n] == 0 ? new Attribute("a" + n) : new Attribute("a" + n, fastVector2);
            fastVector.addElement(attribute);
        }
        for (n = 0; n < fastVector3.capacity(); ++n) {
            fastVector3.addElement("c" + n);
        }
        attribute = new Attribute("class", fastVector3);
        fastVector.addElement(attribute);
        Instances instances = new Instances(this.getRelationNameToUse(), fastVector, this.getNumExamplesAct());
        instances.setClassIndex(this.getNumAttributes());
        Instances instances2 = new Instances(instances, 0);
        this.setDatasetFormat(instances2);
        return instances;
    }

    private boolean[] defineIrrelevant(Random random) {
        int n;
        boolean[] blArray = new boolean[this.getNumAttributes()];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        n = 0;
        for (int i = 0; n < this.getNumIrrelevant() && i < this.getNumAttributes() * 5; ++i) {
            int n2 = (int)(random.nextDouble() * (double)blArray.length);
            if (blArray[n2]) continue;
            blArray[n2] = true;
            ++n;
        }
        return blArray;
    }

    private int[] defineNumeric(Random random) {
        int n;
        int[] nArray = new int[this.getNumAttributes()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 1;
        }
        n = 0;
        for (int i = 0; n < this.getNumNumeric() && i < this.getNumAttributes() * 5; ++i) {
            int n2 = (int)(random.nextDouble() * (double)nArray.length);
            if (nArray[n2] == 0) continue;
            nArray[n2] = 0;
            ++n;
        }
        return nArray;
    }

    public String generateStart() {
        return "";
    }

    public String generateFinished() throws Exception {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean[] blArray = this.getAttList_Irr();
        Instances instances = this.getDatasetFormat();
        stringBuffer.append("%\n% Number of attributes chosen as irrelevant = " + this.getNumIrrelevant() + "\n");
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            stringBuffer.append("% " + instances.attribute(n).name() + "\n");
        }
        stringBuffer.append("%\n% DECISIONLIST (number of rules = " + this.m_DecisionList.size() + "):\n");
        for (n = 0; n < this.m_DecisionList.size(); ++n) {
            RuleList ruleList = (RuleList)this.m_DecisionList.elementAt(n);
            stringBuffer.append("% RULE " + n + ": " + ruleList.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    private Instances voteDataset(Instances instances) throws Exception {
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.firstInstance();
            instance = this.votedReclassifyExample(instance);
            instances.add(instance);
            instances.delete(0);
        }
        return instances;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }

    public static void main(String[] stringArray) {
        RDG1.runDataGenerator(new RDG1(), stringArray);
    }

    private class RuleList
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 2830125413361938177L;
        private FastVector m_RuleList = null;
        double m_ClassValue = 0.0;

        private RuleList() {
        }

        public double getClassValue() {
            return this.m_ClassValue;
        }

        public void setClassValue(double d) {
            this.m_ClassValue = d;
        }

        private void addTest(Test test) {
            if (this.m_RuleList == null) {
                this.m_RuleList = new FastVector();
            }
            this.m_RuleList.addElement(test);
        }

        private double classifyInstance(Instance instance) throws Exception {
            boolean bl = true;
            Enumeration enumeration = this.m_RuleList.elements();
            while (bl && enumeration.hasMoreElements()) {
                Test test = (Test)enumeration.nextElement();
                bl = test.passesTest(instance);
            }
            if (bl) {
                return this.m_ClassValue;
            }
            return -1.0;
        }

        public String toString() {
            Test test;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer = stringBuffer.append("  c" + (int)this.m_ClassValue + " := ");
            Enumeration enumeration = this.m_RuleList.elements();
            if (enumeration.hasMoreElements()) {
                test = (Test)enumeration.nextElement();
                stringBuffer = stringBuffer.append(test.toPrologString());
            }
            while (enumeration.hasMoreElements()) {
                test = (Test)enumeration.nextElement();
                stringBuffer = stringBuffer.append(", " + test.toPrologString());
            }
            return stringBuffer.toString();
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.5 $");
        }
    }
}

