/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.generators;

import java.util.Enumeration;
import weka.classifiers.meta.generators.NominalAttributeGenerator;
import weka.classifiers.meta.generators.RandomizableGenerator;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class NominalGenerator
extends RandomizableGenerator
implements NominalAttributeGenerator {
    private static final long serialVersionUID = 5254947213887016283L;
    protected double[] m_AttCounts;

    public String globalInfo() {
        return "A generator for nominal attributes.\n\nGenerates artificial data for nominal attributes.  Each attribute value is considered to be possible, i.e. the probability of any value is always non-zero.";
    }

    public void buildGenerator(Instances someinstances, Attribute att) {
        this.m_AttCounts = new double[att.numValues()];
        for (int i = 0; i < this.m_AttCounts.length; ++i) {
            this.m_AttCounts[i] = 1.0;
        }
        Enumeration instancesEnum = someinstances.enumerateInstances();
        int totalCounts = this.m_AttCounts.length;
        while (instancesEnum.hasMoreElements()) {
            Instance aninst = (Instance)instancesEnum.nextElement();
            if (aninst.isMissing(att)) continue;
            int n = (int)aninst.value(att);
            this.m_AttCounts[n] = this.m_AttCounts[n] + 1.0;
            ++totalCounts;
        }
        int i = 0;
        while (i < this.m_AttCounts.length) {
            int n = i++;
            this.m_AttCounts[n] = this.m_AttCounts[n] / (double)totalCounts;
        }
    }

    public double generate() {
        double prob = this.m_Random.nextDouble();
        double probSoFar = 0.0;
        for (int i = 0; i < this.m_AttCounts.length; ++i) {
            if (!(prob <= (probSoFar += this.m_AttCounts[i]))) continue;
            return i;
        }
        return 0.0;
    }

    public double getProbabilityOf(double valuex) {
        return this.m_AttCounts[(int)valuex];
    }

    public double getLogProbabilityOf(double valuex) {
        return Math.log(this.getProbabilityOf(valuex));
    }
}

