/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.scripting;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.scripting.Groovy;

public class GroovyClassifier
extends AbstractClassifier {
    private static final long serialVersionUID = -9078371491735496175L;
    protected File m_GroovyModule = new File(System.getProperty("user.dir"));
    protected String[] m_GroovyOptions = new String[0];
    protected transient Classifier m_GroovyObject = null;

    public String globalInfo() {
        return "A wrapper class for Groovy code. Even though the classifier is serializable, the trained classifier cannot be stored persistently. I.e., one cannot store a model file and re-load it at a later point in time again to make predictions.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe Groovy module to load (full path)\n\tOptions after '--' will be passed on to the Groovy module.", "G", 1, "-G <filename>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.m_GroovyOptions = new String[0];
        String tmpStr = Utils.getOption('G', options);
        if (tmpStr.length() != 0) {
            this.setGroovyModule(new File(tmpStr));
        } else {
            this.setGroovyModule(new File(System.getProperty("user.dir")));
        }
        this.setGroovyOptions(Utils.joinOptions((String[])Utils.partitionOptions(options).clone()));
        super.setOptions(options);
    }

    public String[] getOptions() {
        int i;
        Vector<String> result = new Vector<String>();
        result.add("-G");
        result.add("" + this.getGroovyModule().getAbsolutePath());
        String[] options = super.getOptions();
        for (i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.m_GroovyOptions.length > 0) {
            options = this.m_GroovyOptions;
            result.add("--");
            for (i = 0; i < options.length; ++i) {
                result.add(options[i]);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String GroovyModuleTipText() {
        return "The Groovy module to load and execute.";
    }

    public void setGroovyModule(File value) {
        this.m_GroovyModule = value;
        this.initGroovyObject();
    }

    public File getGroovyModule() {
        return this.m_GroovyModule;
    }

    public String GroovyOptionsTipText() {
        return "The options for the Groovy module.";
    }

    public void setGroovyOptions(String value) {
        try {
            this.m_GroovyOptions = (String[])Utils.splitOptions(value).clone();
            this.initGroovyObject();
        }
        catch (Exception e) {
            this.m_GroovyOptions = new String[0];
            e.printStackTrace();
        }
    }

    public String getGroovyOptions() {
        return Utils.joinOptions(this.m_GroovyOptions);
    }

    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.m_GroovyObject == null) {
            result = new Capabilities(this);
            result.disableAll();
        } else {
            result = this.m_GroovyObject.getCapabilities();
        }
        result.enableAllAttributeDependencies();
        result.enableAllClassDependencies();
        return result;
    }

    protected void initGroovyObject() {
        try {
            this.m_GroovyObject = this.m_GroovyModule.isFile() ? (Classifier)Groovy.newInstance(this.m_GroovyModule, Classifier.class) : null;
            if (this.m_GroovyObject != null) {
                ((OptionHandler)((Object)this.m_GroovyObject)).setOptions((String[])this.m_GroovyOptions.clone());
            }
        }
        catch (Exception e) {
            this.m_GroovyObject = null;
            e.printStackTrace();
        }
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!Groovy.isPresent()) {
            throw new Exception("Groovy classes not in CLASSPATH!");
        }
        this.initGroovyObject();
        if (this.m_GroovyObject != null) {
            this.m_GroovyObject.buildClassifier(instances);
        } else {
            System.err.println("buildClassifier: No Groovy object present!");
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_GroovyObject != null) {
            return this.m_GroovyObject.classifyInstance(instance);
        }
        return Utils.missingValue();
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_GroovyObject != null) {
            return this.m_GroovyObject.distributionForInstance(instance);
        }
        return new double[instance.numClasses()];
    }

    public String toString() {
        if (this.m_GroovyObject != null) {
            return this.m_GroovyObject.toString();
        }
        return "No Groovy module loaded.";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] args) {
        GroovyClassifier.runClassifier(new GroovyClassifier(), args);
    }
}

