/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.scripting;

import java.io.File;
import javax.swing.text.Document;
import weka.core.scripting.Groovy;
import weka.gui.ExtensionFileFilter;
import weka.gui.scripting.Script;

public class GroovyScript
extends Script {
    private static final long serialVersionUID = -3708517162415549420L;

    public GroovyScript() {
    }

    public GroovyScript(Document doc) {
        super(doc);
    }

    public GroovyScript(Document doc, File file) {
        super(doc, file);
    }

    public ExtensionFileFilter[] getFilters() {
        ExtensionFileFilter[] result = new ExtensionFileFilter[]{new ExtensionFileFilter(this.getDefaultExtension(), "Groovy script (*" + this.getDefaultExtension() + ")")};
        return result;
    }

    public String getDefaultExtension() {
        return ".groovy";
    }

    protected boolean canExecuteScripts() {
        return Groovy.isPresent();
    }

    protected void preCheck(String[] args) throws Exception {
        super.preCheck(args);
        if (!Groovy.isPresent()) {
            throw new Exception("Groovy classes are not present in CLASSPATH!");
        }
    }

    public Script.ScriptThread newThread(String[] args) {
        return new GroovyThread(this, args);
    }

    public static void main(String[] args) throws Exception {
        GroovyScript.runScript(new GroovyScript(), args);
    }

    public static class GroovyThread
    extends Script.ScriptThread {
        public GroovyThread(Script owner, String[] args) {
            super(owner, args);
        }

        protected boolean hasMethod(Object groovy, String name) {
            boolean result;
            try {
                groovy.getClass().getMethod(name, String[].class);
                result = true;
            }
            catch (Exception e) {
                result = false;
            }
            return result;
        }

        protected void doRun() {
            Object groovy = Groovy.newInstance(this.m_Owner.getFilename(), Object.class);
            if (this.hasMethod(groovy, "run")) {
                Groovy.invoke(groovy, "run", new Class[]{String[].class}, new Object[]{this.getArgs()});
            } else if (this.hasMethod(groovy, "main")) {
                Groovy.invoke(groovy, "main", new Class[]{String[].class}, new Object[]{this.getArgs()});
            } else {
                throw new IllegalStateException("Neither 'run' nor 'main' method found!");
            }
        }
    }
}

