/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.ClassDiscovery;
import weka.core.Javadoc;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class TechnicalInformationHandlerJavadoc
extends Javadoc {
    public static final String PLAINTEXT_STARTTAG = "<!-- technical-plaintext-start -->";
    public static final String PLAINTEXT_ENDTAG = "<!-- technical-plaintext-end -->";
    public static final String BIBTEX_STARTTAG = "<!-- technical-bibtex-start -->";
    public static final String BIBTEX_ENDTAG = "<!-- technical-bibtex-end -->";
    protected boolean m_Prolog = true;

    public TechnicalInformationHandlerJavadoc() {
        this.m_StartTag = new String[2];
        this.m_EndTag = new String[2];
        this.m_StartTag[0] = PLAINTEXT_STARTTAG;
        this.m_EndTag[0] = PLAINTEXT_ENDTAG;
        this.m_StartTag[1] = BIBTEX_STARTTAG;
        this.m_EndTag[1] = BIBTEX_ENDTAG;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addAll(Collections.list(super.listOptions()));
        result.addElement(new Option("\tSuppresses the 'BibTex:' prolog in the Javadoc.", "noprolog", 0, "-noprolog"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        this.setProlog(!Utils.getFlag("noprolog", options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (!this.getProlog()) {
            result.add("-noprolog");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setProlog(boolean value) {
        this.m_Prolog = value;
    }

    public boolean getProlog() {
        return this.m_Prolog;
    }

    @Override
    protected String generateJavadoc(int index) throws Exception {
        String result = "";
        if (!this.canInstantiateClass()) {
            return result;
        }
        if (!ClassDiscovery.hasInterface(TechnicalInformationHandler.class, this.getInstance().getClass())) {
            throw new Exception("Class '" + this.getClassname() + "' is not a TechnicalInformationHandler!");
        }
        TechnicalInformationHandler handler = (TechnicalInformationHandler)this.getInstance();
        switch (index) {
            case 0: {
                result = this.toHTML(handler.getTechnicalInformation().toString()) + "\n";
                break;
            }
            case 1: {
                if (this.getProlog()) {
                    result = "BibTeX:\n";
                }
                result = result + "<pre>\n";
                result = result + this.toHTML(handler.getTechnicalInformation().toBibTex()).replaceAll("<br/>", "") + "\n";
                result = result + "</pre>\n<p/>\n";
            }
        }
        if (this.getUseStars()) {
            result = this.indent(result, 1, "* ");
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }

    public static void main(String[] args) {
        TechnicalInformationHandlerJavadoc.runJavadoc(new TechnicalInformationHandlerJavadoc(), args);
    }
}

