/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import weka.classifiers.functions.supportVector.PolyKernel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class NormalizedPolyKernel
extends PolyKernel {
    static final long serialVersionUID = 1248574185532130851L;

    public NormalizedPolyKernel() {
        this.setExponent(2.0);
    }

    public NormalizedPolyKernel(Instances dataset, int cacheSize, double exponent, boolean lowerOrder) throws Exception {
        super(dataset, cacheSize, exponent, lowerOrder);
    }

    @Override
    public String globalInfo() {
        return "The normalized polynomial kernel.\nK(x,y) = <x,y>/sqrt(<x,x><y,y>) where <x,y> = PolyKernel(x,y)";
    }

    @Override
    public double eval(int id1, int id2, Instance inst1) throws Exception {
        double div = Math.sqrt(super.eval(id1, id1, inst1) * (this.m_keys != null ? super.eval(id2, id2, this.m_data.instance(id2)) : super.eval(-1, -1, this.m_data.instance(id2))));
        if (div != 0.0) {
            return super.eval(id1, id2, inst1) / div;
        }
        return 0.0;
    }

    @Override
    public void setExponent(double value) {
        if (value != 1.0) {
            super.setExponent(value);
        } else {
            System.out.println("A linear kernel, i.e., Exponent=1, is not possible!");
        }
    }

    @Override
    public String toString() {
        String result = this.getUseLowerOrder() ? "Normalized Poly Kernel with lower order: K(x,y) = (<x,y>+1)^" + this.getExponent() + "/" + "((<x,x>+1)^" + this.getExponent() + "*" + "(<y,y>+1)^" + this.getExponent() + ")^(1/2)" : "Normalized Poly Kernel: K(x,y) = <x,y>^" + this.getExponent() + "/" + "(<x,x>^" + this.getExponent() + "*" + "<y,y>^" + this.getExponent() + ")^(1/2)";
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

