/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class AddNoise
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = -8499673222857299082L;
    private final SingleIndex m_AttIndex = new SingleIndex("last");
    private boolean m_UseMissing = false;
    private int m_Percent = 10;
    private int m_RandomSeed = 1;

    public String globalInfo() {
        return "An instance filter that changes a percentage of a given attributes values. The attribute must be nominal. Missing value can be treated as value itself.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tIndex of the attribute to be changed \n\t(default last attribute)", "C", 1, "-C <col>"));
        newVector.addElement(new Option("\tTreat missing values as an extra value \n", "M", 1, "-M"));
        newVector.addElement(new Option("\tSpecify the percentage of noise introduced \n\tto the data (default 10)", "P", 1, "-P <num>"));
        newVector.addElement(new Option("\tSpecify the random number seed (default 1)", "S", 1, "-S <num>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String percentString;
        String indexString = Utils.getOption('C', options);
        if (indexString.length() != 0) {
            this.setAttributeIndex(indexString);
        } else {
            this.setAttributeIndex("last");
        }
        if (Utils.getFlag('M', options)) {
            this.setUseMissing(true);
        }
        if ((percentString = Utils.getOption('P', options)).length() != 0) {
            this.setPercent((int)Double.valueOf(percentString).doubleValue());
        } else {
            this.setPercent(10);
        }
        String seedString = Utils.getOption('S', options);
        if (seedString.length() != 0) {
            this.setRandomSeed(Integer.parseInt(seedString));
        } else {
            this.setRandomSeed(1);
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-C");
        options.add("" + this.getAttributeIndex());
        if (this.getUseMissing()) {
            options.add("-M");
        }
        options.add("-P");
        options.add("" + this.getPercent());
        options.add("-S");
        options.add("" + this.getRandomSeed());
        return options.toArray(new String[0]);
    }

    public String useMissingTipText() {
        return "Flag to set if missing values are used.";
    }

    public boolean getUseMissing() {
        return this.m_UseMissing;
    }

    public void setUseMissing(boolean newUseMissing) {
        this.m_UseMissing = newUseMissing;
    }

    public String randomSeedTipText() {
        return "Random number seed.";
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int newSeed) {
        this.m_RandomSeed = newSeed;
    }

    public String percentTipText() {
        return "Percentage of introduced noise to data.";
    }

    public int getPercent() {
        return this.m_Percent;
    }

    public void setPercent(int newPercent) {
        this.m_Percent = newPercent;
    }

    public String attributeIndexTipText() {
        return "Index of the attribute that is to changed.";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String attIndex) {
        this.m_AttIndex.setSingleIndex(attIndex);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndex.setUpper(this.getInputFormat().numAttributes() - 1);
        if (!this.getInputFormat().attribute(this.m_AttIndex.getIndex()).isNominal()) {
            throw new Exception("Adding noise is not possible:Chosen attribute is numeric.");
        }
        if (this.getInputFormat().attribute(this.m_AttIndex.getIndex()).numValues() < 2 && !this.m_UseMissing) {
            throw new Exception("Adding noise is not possible:Chosen attribute has less than two values.");
        }
        this.setOutputFormat(this.getInputFormat());
        this.m_NewBatch = true;
        return false;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new Exception("No input instance format defined");
        }
        this.addNoise(this.getInputFormat(), this.m_RandomSeed, this.m_Percent, this.m_AttIndex.getIndex(), this.m_UseMissing);
        for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
            this.push((Instance)this.getInputFormat().instance(i).copy(), false);
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public void addNoise(Instances instances, int seed, int percent, int attIndex, boolean useMissing) {
        double splitPercent = percent;
        int[] indexList = new int[instances.numInstances()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            indexList[i] = i;
        }
        Random random = new Random(seed);
        for (int i = instances.numInstances() - 1; i >= 0; --i) {
            int hValue = indexList[i];
            int hIndex = (int)(random.nextDouble() * (double)i);
            indexList[i] = indexList[hIndex];
            indexList[hIndex] = hValue;
        }
        int numValues = instances.attribute(attIndex).numValues();
        int[] partition_count = new int[numValues];
        int[] partition_max = new int[numValues];
        int missing_count = 0;
        int missing_max = 0;
        for (int i = 0; i < numValues; ++i) {
            partition_count[i] = 0;
            partition_max[i] = 0;
        }
        for (Object element : instances) {
            Instance instance = (Instance)element;
            if (instance.isMissing(attIndex)) {
                ++missing_max;
                continue;
            }
            instance.value(attIndex);
            int n = (int)instance.value(attIndex);
            partition_max[n] = partition_max[n] + 1;
        }
        missing_max = !useMissing ? missing_count : (int)((double)missing_max / 100.0 * splitPercent + 0.5);
        int sum_max = missing_max;
        for (int i = 0; i < numValues; ++i) {
            partition_max[i] = (int)((double)partition_max[i] / 100.0 * splitPercent + 0.5);
            sum_max += partition_max[i];
        }
        int sum_count = 0;
        Random randomValue = new Random(seed);
        int numOfValues = instances.attribute(attIndex).numValues();
        for (int i = 0; i < instances.numInstances() && sum_count < sum_max; ++i) {
            Instance currInstance = instances.instance(indexList[i]);
            if (currInstance.isMissing(attIndex)) {
                if (missing_count >= missing_max) continue;
                this.changeValueRandomly(randomValue, numOfValues, attIndex, currInstance, useMissing);
                ++missing_count;
                ++sum_count;
                continue;
            }
            int vIndex = (int)currInstance.value(attIndex);
            if (partition_count[vIndex] >= partition_max[vIndex]) continue;
            this.changeValueRandomly(randomValue, numOfValues, attIndex, currInstance, useMissing);
            int n = vIndex;
            partition_count[n] = partition_count[n] + 1;
            ++sum_count;
        }
    }

    private void changeValueRandomly(Random r, int numOfValues, int indexOfAtt, Instance instance, boolean useMissing) {
        int currValue = instance.isMissing(indexOfAtt) ? numOfValues : (int)instance.value(indexOfAtt);
        if (numOfValues == 2 && !instance.isMissing(indexOfAtt)) {
            instance.setValue(indexOfAtt, (double)((currValue + 1) % 2));
        } else {
            int newValue;
            while ((newValue = useMissing ? (int)(r.nextDouble() * (double)(numOfValues + 1)) : (int)(r.nextDouble() * (double)numOfValues)) == currValue) {
            }
            if (newValue == numOfValues) {
                instance.setMissing(indexOfAtt);
            } else {
                instance.setValue(indexOfAtt, (double)newValue);
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12037 $");
    }

    public static void main(String[] argv) {
        AddNoise.runFilter(new AddNoise(), argv);
    }
}

