/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.SimpleBatchFilter;

public class DateToNumeric
extends SimpleBatchFilter
implements WeightedInstancesHandler,
WeightedAttributesHandler {
    private static final long serialVersionUID = -6614650822291796239L;
    protected Range m_Cols = new Range("first-last");
    protected String m_DefaultCols = "first-last";

    @Override
    public String globalInfo() {
        return "A filter for turning date attributes into numeric ones. The numeric value will be the number of milliseconds since January 1, 1970, 00:00:00 GMT, corresponding to the given date.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>(2);
        result.addElement(new Option("\tSpecifies list of columns to convert. First and last are valid indexes.\n\t(default: first-last)", "R", 1, "-R <col1,col2-col4,...>"));
        result.addElement(new Option("\tInvert matching sense of column indexes.", "V", 0, "-V"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setInvertSelection(Utils.getFlag('V', options));
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices(this.m_DefaultCols);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (!this.getAttributeIndices().equals("")) {
            result.add("-R");
            result.add(this.getAttributeIndices());
        }
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected (date) attributes in the range will be turned into numeric attributes; if true, only non-selected attributes will be turned into numeric attributes.";
    }

    public boolean getInvertSelection() {
        return this.m_Cols.getInvert();
    }

    public void setInvertSelection(boolean value) {
        this.m_Cols.setInvert(value);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_Cols.getRanges();
    }

    public void setAttributeIndices(String value) {
        this.m_Cols.setRanges(value);
    }

    public void setAttributeIndicesArray(int[] value) {
        this.setAttributeIndices(Range.indicesToRangeList(value));
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances data) throws Exception {
        this.m_Cols.setUpper(data.numAttributes() - 1);
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < data.numAttributes(); ++i) {
            if (!this.m_Cols.isInRange(i) || !data.attribute(i).isDate()) {
                atts.add(data.attribute(i));
                continue;
            }
            Attribute newAtt = new Attribute(data.attribute(i).name());
            newAtt.setWeight(data.attribute(i).weight());
            atts.add(newAtt);
        }
        Instances result = new Instances(data.relationName(), atts, 0);
        result.setClassIndex(data.classIndex());
        return result;
    }

    @Override
    protected boolean hasImmediateOutputFormat() {
        return true;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        Instances result = this.getOutputFormat();
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance newInst = (Instance)instances.instance(i).copy();
            this.copyValues(newInst, false, instances, this.outputFormatPeek());
            result.add(newInst);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14274 $");
    }

    public static void main(String[] args) {
        DateToNumeric.runFilter(new DateToNumeric(), args);
    }
}

