% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.weight.R
\name{overlap.weight}
\alias{overlap.weight}
\title{Weight Raster Cells by Overlapping Polygons}
\usage{
overlap.weight(raster, polygons, count = FALSE, warn = TRUE)
}
\arguments{
\item{raster}{a RasterLayer object.}

\item{polygons}{a SpatialPolygons, SpatialPolygonsDataFrame, or simple feature
collection with at least two features. The function will still work with only
one polygon, but values will be unchanged, and the result will be equivalent
to \code{mask(raster, polygons)}.}

\item{count}{a logical indicating whether to return a raster with the count of
polygons intersecting each cell, or a raster with original values weighted by
1/number of intersecting polygons.}

\item{warn}{include warnings? Most common is that the returned raster will be
an intersection of the raster and the polygons. Default \code{TRUE}.}
}
\value{
a RasterLayer object.
}
\description{
Weight raster cells by overlapping polygons to avoid over-counting when aggregating by polygons
}
\details{
This function takes a raster and a set of polygons as arguments.
It counts the number of polygons that intersect each raster cell. It can
return either a raster with the count of the number of intersecting polygons
as cell values or the original raster with cell values weighted by 1 / the
number of intersecting polygons (the default behavior). Cells that do not
intersect any polygons will receive a value of \code{NA}. If the extent of the
polygons is less than the extent of the raster, then the function will warn
that it is cropping the raster to the polygons' extent.
}
\examples{
library(sf)
library(raster)
polys_t <- st_sfc(list(st_polygon(list(rbind(c(2,2), c(2,6),
                                             c(6,6), c(6,2),
                                             c(2, 2)))),
                       st_polygon(list(rbind(c(8,8), c(4,8),
                                             c(4,4), c(8,4),
                                             c(8,8))))),
                  crs = 4326)
raster_t <- raster(nrows = 10, ncols = 10, xmn = 0,
                   xmx = 10, ymn = 0, ymx = 10,
                   vals = 1:100,
                   crs = CRS(st_crs(polys_t)$proj4string))
overlap.weight(raster_t, polys_t)
}
