% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_down.R
\name{p_down}
\alias{p_down}
\alias{p_down0}
\title{Download Package Documentation in One Directory or Several Subdirectories}
\usage{
p_down(..., char = NULL, index = TRUE, manual = TRUE,
  vignettes = TRUE, README = TRUE, NEWS = FALSE, ChangeLog = FALSE,
  checks = FALSE, targz = FALSE, script = FALSE, dir = ".",
  crandb = get("crandb", envir = .GlobalEnv),
  repos = getOption("repos")[1])

p_down0(..., char = NULL, index = FALSE, manual = FALSE,
  vignettes = FALSE, README = FALSE, NEWS = FALSE,
  ChangeLog = FALSE, checks = FALSE, targz = FALSE, script = FALSE,
  dir = ".", crandb = get("crandb", envir = .GlobalEnv),
  repos = getOption("repos")[1])
}
\arguments{
\item{...}{any format recognized by \code{\link{cnsc}}, including list.
A vector or packages or a named list of packages (with names 
being the keywords).}

\item{char}{(name to) a character vector or a list. Use this argument if 
\code{...} fails or if you call the function from another function. 
If used, argument \code{...} is ignored.}

\item{index}{logical. Download the html index page of each package.}

\item{manual}{logical. Download the pdf manual.}

\item{vignettes}{logical. Download the html and pdf vignettes, if they exist.}

\item{README}{logical. Download the README file, if it exists.}

\item{NEWS}{logical. Download the NEWS file, if it exists.}

\item{ChangeLog}{logical. Download the ChangeLog file, if it exists.}

\item{checks}{logical. Download the CRAN checks file.}

\item{targz}{logical. Download the *.tar.gz source file.}

\item{script}{logical. Create a mini-script to test the package.}

\item{dir}{character. The directory in which the files are saved. 
Default value \code{"."} is the current directory.}

\item{crandb}{data.frame \code{crandb}. The data.frame of CRAN packages.}

\item{repos}{character. The address of your local CRAN.}
}
\description{
If \code{pkgs} is a vector of packages obtained from \code{\link{s_crandb}}, 
\code{p_down} downloads from CRAN and saves in the \code{dir} directory (by default 
the current directory) the index page, the manual, the vignettes, the README, NEWS,
ChangeLog, CRAN checks files, the source code in \emph{pkg_ver.tar.gz} format and 
a minimal R-script of each package. The files that do not exist in CRAN are ignored, 
with no warning. 

If \code{pkgs} is a list of packages obtained from \code{\link{s_crandb_list}}, 
\code{p_down} saves the downloaded files in subdirectories named after the names 
of the list, e.g. the keywords used at the search step. The names are  
eventually modified with \code{gsub(".", "_", make.names(pkg), fixed = TRUE)}
to cope with Unix and Windows directory names.

\code{p_down0} calls \code{p_down} with different values for each argument. 
With the default configuration, this function downloads nothing. It is mostly used 
to download one specific item which has not been previously downloaded. 

Visit \code{\link{p_downarch}} to download tar.gz file(s) from CRAN archive.
}
\examples{
## In real life, download crandb from CRAN or load it from your directory 
## with functions crandb_down() or crandb_load(). 
## In this example, we use a small file.
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))
\donttest{
## Download the documentation in the "dirpkgs" directory. Flat representation.
p_down(pacman, pdfsearch, sos, dir = "dirpkgs", repos = "https://cran.univ-paris1.fr")

## Download the documentation in subdirectories named after the keywords.
(lst <- s_crandb_list(thermodynamic, "chemical reaction"))
p_down(lst, dir = "dirpkgslist", repos = "https://cran.univ-paris1.fr") 
}
}
