% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crandb.R
\name{crandb}
\alias{crandb}
\alias{crandb_down}
\alias{crandb_load}
\alias{crandb_comp}
\alias{crandb_pkgs}
\alias{crandb_fromto}
\title{CRAN Packages (crandb.rda)}
\usage{
crandb_down(dir = ".", oldfile = "crandb.rda", verbose = TRUE,
  repos = getOption("repos")[1])

crandb_load(filename = "crandb.rda")

crandb_comp(filename = "crandb.rda", oldfile = "crandb-old.rda",
  addtxt = "")

crandb_pkgs(bydate = FALSE, rev = FALSE, crandb = get("crandb", envir
  = .GlobalEnv))

crandb_fromto(from = -10, to = Sys.Date(), crandb = get("crandb",
  envir = .GlobalEnv))
}
\arguments{
\item{dir}{character. The directory where "crandb.rda" is saved and the old
"crandb.rda" is read. Default value \code{"."} is the current 
directory.}

\item{oldfile}{character or NULL. The (path to an) old file that will be compared 
to a freshly downloaded version of "crandb.rda" or to \code{filename}. 
Set to \code{NULL} if no comparison is required.}

\item{verbose}{logical. \code{TRUE} prints the result. \code{FALSE} keeps it invisible.}

\item{repos}{character. The address of your local CRAN.}

\item{filename}{character. The (path to a) file "crandb.rda" or an equivalent.}

\item{addtxt}{character. Internal use.}

\item{bydate}{logical. List the package by date of publication rather than by 
alphabetical order.}

\item{rev}{logical. Print in reverse order.}

\item{crandb}{data.frame \code{crandb}. The data.frame of CRAN packages.}

\item{from}{Negative integer or character representing a date. The number of
days preceeding \code{to} or a date before \code{to}.}

\item{to}{date. The upper date in the search.}
}
\description{
\code{crandb_down} downloads from CRAN the file \emph{packages.rds}, a file refreshed 
everyday that describes the packages available in CRAN for this day, rename (with 
\code{make.names}) the column names that are syntactically invalid, removes the 
duplicated lines located at the end of the file, cleans some bad characters in the 
Description column, loads the resulting data.frame in .GlobalEnv under the name 
\emph{crandb} and saves it in the current directory with the name \code{crandb.rda}. 
If \code{oldfile} is defined, the vector of packages between the two files is compared.

\code{crandb_load} loads the file \code{filename} in .GlobalEnv under the name 
\code{crandb}. Equivalent to \code{load("crandb.rda")}. Use this function if you are 
not connected to internet or do not want to refresh your file.

\code{crandb_pkgs} displays all packages listed in \code{crandb}. The number of 
packages is larger than the number obtained with \code{nrow(available.packages())} 
since packages for all OSes are counted.

\code{crandb_fromto} displays the packages published in CRAN between two dates.
}
\examples{
### In this first example, we use a small file.
## List the 50 packages of this file, the ones uploaded since 2019-01-01
## and those uploaded in the last 15 days before the last date (2019-02-10)
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))
crandb_pkgs()
dim(crandb)   
colnames(crandb) 
crandb$Published
crandb_fromto(from = "2019-01-01", to = Sys.Date())
crandb_fromto(from = -15, to = max(crandb$Published))
\donttest{
### Now, we use the big file (7 MB) that contains the list of all packages.
## Download from your local CRAN a fresh version of crandb (5-20 seconds) 
## and query the packages of the last 2 days
crandb_down(dir = tempdir(), repos = "https://cloud.r-project.org") 
ls() 
pkgs <- crandb_fromto(-2) ; pkgs
p_table2(pkgs)   # Print in the console (better if full width)
p_display7(pkgs, dir = tempdir())   # Display in the browser
}
}
