% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zplot_vertical.R
\name{zooplot_partitioning}
\alias{zooplot_partitioning}
\title{Plot the partitioning of the genome in different HBD classes for each individual}
\usage{
zooplot_partitioning(input, cols = NULL, plotids = TRUE,
  toplot = NULL, randomids = FALSE, nrandom = NULL, seed = 100,
  ylim = c(0, 1), border = TRUE, nonhbd = TRUE, vertical = FALSE)
}
\arguments{
\item{input}{a named list with one or several zres objects obtained after
running zoorun. The zres objects are the output of the zoorun function. For
instance, putting list(name1 = zres1, name2 = zres2). The function will then
use the names in the plot (in case several zres objects are used).}

\item{cols}{A vector with the colors to be used for each class in the model.}

\item{plotids}{A logical indicating whether the IDs of the individuals are
plotted on the graph (TRUE by default).}

\item{toplot}{A list of vectors indicating the zres@ids to be plotted. This
option can be used to select the individuals to plot. The list must contain
one vector per population or zres object. By default, all individuals are
plotted.}

\item{randomids}{A logical indicating whether a randomset of individuals is
plotted. This option allows to reduce the number of individuals in the plot.
The option can not be used simultaneously with the toplot option. By
default, randomids is FALSE.}

\item{nrandom}{A vector indicating the number of individuals to be randomly
sampled per population or per zres object when randomids is TRUE. By
default, we select 10 individuals per zres object. This vector must have the
same length as the input list.}

\item{seed}{A value for the random seed used to sample individuals to plot
(when the randomids option is TRUE).}

\item{ylim}{The limits of the y-axis.}

\item{border}{Whether a border is plotted around each block of the barplot
or not. When set to FALSE, it allows to get a less dense plot when many
individuals are plotted.}

\item{nonhbd}{Whether the a border is plotted around the non-hbd contribution.
When set to FALSE, it allows to get a less dense plot when many individuals
are plotted.}

\item{vertical}{Whether the populations or zres labels are printed vertically
or not.}
}
\value{
Individuals are presented with stacked barplots. Each vertical stack of bars
represents one individual. Each class is represented with a bar of a different
color. The height of the bar represents the proportion associated
with the corresponding class. The total height of the stack is the total
autozygosity.
}
\description{
Plot the partitioning of the genome in different HBD classes for each individual
}
