% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grabMzxmlFunctions.R
\name{grabMzxmlBPC}
\alias{grabMzxmlBPC}
\title{Grab the BPC or TIC from a file}
\usage{
grabMzxmlBPC(xml_data, TIC = FALSE, rtrange, incl_polarity)
}
\arguments{
\item{xml_data}{An `xml2` nodeset, usually created by applying `read_xml` to
an mzML file.}

\item{TIC}{Boolean. If TRUE, the TIC is extracted rather than the BPC.}

\item{rtrange}{A vector of length 2 containing an upper and lower bound on
retention times of interest. Providing a range here can speed up load times
(although not enormously, as the entire file must still be read) and reduce
the final object's size.}

\item{incl_polarity}{Boolean determining whether the polarity of the scan
should be returned as a column in the table (positive mode = 1, negative
mode = -1)}
}
\value{
A `data.table` with columns for retention time (rt), and intensity (int).
}
\description{
The base peak intensity and total ion current are actually written into the
mzXML files and aren't encoded, making retrieval of BPC and TIC information
blazingly fast if parsed correctly.
}
