% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{plotPearsonRes}
\alias{plotPearsonRes}
\title{Function for plotting the variance of Pearson residuals}
\usage{
plotPearsonRes(noise, log = FALSE)
}
\arguments{
\item{noise}{List object with the background noise model and a variability matrix, returned by the \code{compNoise} function.}

\item{log}{logical. If \code{TRUE} then the y-axis is log-transformed. Default is \code{FALSE}.}
}
\value{
None
}
\description{
This function plots the variance versus the mean of the Pearson residuals obtained by the negative binomial regression computed by the function \code{compNoise} if \code{regNB} is \code{TRUE}. A local regression is also shown.
}
\examples{
res <- pruneKnn(intestinalDataSmall,metric="pearson",knn=10,alpha=1,no_cores=1,FSelect=FALSE)
noise <- compNoise(intestinalDataSmall,res,pvalue=0.01,genes = NULL,no_cores=1)
plotPearsonRes(noise,log=TRUE)
}
