% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_ggplot.R
\name{ggplot.acmap}
\alias{ggplot.acmap}
\title{Plot an antigenic map using ggplot}
\usage{
\method{ggplot}{acmap}(
  data = NULL,
  mapping = NULL,
  optimization_number = 1,
  xlim = NULL,
  ylim = NULL,
  plot_ags = TRUE,
  plot_sr = TRUE,
  plot_blobs = TRUE,
  plot_hemisphering = TRUE,
  show_procrustes = TRUE,
  show_error_lines = FALSE,
  plot_stress = FALSE,
  indicate_outliers = "arrowheads",
  grid.col = "grey90",
  grid.lwd = 0.5,
  grid.margin.col = "grey50",
  grid.margin.lwd = grid.lwd,
  fill.alpha = 0.8,
  outline.alpha = 0.8,
  padding = 1,
  arrow_angle = 25,
  arrow_length = 0.2,
  margins = rep(0.5, 4),
  ...,
  environment = NULL
)
}
\arguments{
\item{data}{The acmap to plot}

\item{mapping}{Default list of aesthetic mappings to use for plot, not currently used}

\item{optimization_number}{The optimization number to plot}

\item{xlim}{optional x axis limits}

\item{ylim}{optional y axis limits}

\item{plot_ags}{logical, should antigens be plotted}

\item{plot_sr}{logical, should antigens be plotted}

\item{plot_blobs}{logical, should stress blobs be plotted if present}

\item{plot_hemisphering}{logical, should hemisphering points be indicated, if
tested for already with \code{checkHemisphering()} (and if present)}

\item{show_procrustes}{logical, should procrustes lines be shown, if present}

\item{show_error_lines}{logical, should error lines be drawn}

\item{plot_stress}{logical, should map stress be plotted in lower left corner}

\item{indicate_outliers}{how should points outside the plotting region be
indicated, either FALSE, for not shown, or "arrowheads" for small arrowheads
like in the viewer.}

\item{grid.col}{grid line color}

\item{grid.lwd}{grid line width}

\item{grid.margin.col}{grid margin color}

\item{grid.margin.lwd}{grid margin line width}

\item{fill.alpha}{alpha for point fill}

\item{outline.alpha}{alpha for point outline}

\item{padding}{padding at limits of the antigenic map, ignored if xlim or
ylim set explicitly}

\item{arrow_angle}{angle of arrow heads drawn for procrustes lines}

\item{arrow_length}{length of arrow heads drawn for procrustes lines in cm}

\item{margins}{margins in inches for the plot}

\item{...}{additional arguments, not used}

\item{environment}{not used}
}
\value{
Returns the ggplot plot
}
\description{
Method for plotting an antigenic map as a ggplot object
}
\seealso{
Other functions to view maps: 
\code{\link{RacViewer.options}()},
\code{\link{RacViewer}()},
\code{\link{export_viewer}()},
\code{\link{mapGadget}()},
\code{\link{plot.acmap}()},
\code{\link{setLegend}()},
\code{\link{view.acmap}()},
\code{\link{view.default}()},
\code{\link{view}()}
}
\concept{functions to view maps}
