% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_optimizations.R
\name{addOptimization}
\alias{addOptimization}
\title{Add a new optimization to an acmap object}
\usage{
addOptimization(
  map,
  ag_coords = NULL,
  sr_coords = NULL,
  number_of_dimensions = NULL,
  minimum_column_basis = "none",
  fixed_column_bases = NULL,
  ag_reactivity_adjustments = NULL
)
}
\arguments{
\item{map}{The acmap data object}

\item{ag_coords}{Antigen coordinates for the new optimization (0 if not
specified)}

\item{sr_coords}{Sera coordinates for the new optimization (0 if not
specified)}

\item{number_of_dimensions}{The number of dimensions of the new optimization}

\item{minimum_column_basis}{The minimum column basis to use for the new
optimization}

\item{fixed_column_bases}{A vector of fixed column bases with NA for sera
where the minimum column basis should be applied}

\item{ag_reactivity_adjustments}{A vector of antigen reactivity adjustments to
apply to each antigen. Corresponding antigen titers will be adjusted by these
amounts when calculating column bases and table distances.}
}
\value{
Returns the acmap data object with new optimization added (but not
selected).
}
\description{
Function to add a new optimization to an acmap object, with specified values.
}
\seealso{
Other functions for working with map data: 
\code{\link{acmap}()},
\code{\link{agReactivityAdjustments}()},
\code{\link{as.json}()},
\code{\link{edit_agNames}()},
\code{\link{edit_srNames}()},
\code{\link{keepBestOptimization}()},
\code{\link{keepSingleOptimization}()},
\code{\link{layerNames}()},
\code{\link{orderPoints}},
\code{\link{read.acmap}()},
\code{\link{read.titerTable}()},
\code{\link{removePoints}},
\code{\link{save.acmap}()},
\code{\link{save.coords}()},
\code{\link{save.titerTable}()},
\code{\link{subsetCommonPoints}},
\code{\link{subsetMap}()}
}
\concept{functions for working with map data}
