% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_loadsave.R
\name{save.acmap}
\alias{save.acmap}
\title{Save acmap data to a file}
\usage{
save.acmap(
  map,
  filename,
  compress = FALSE,
  pretty = !compress,
  round_titers = FALSE
)
}
\arguments{
\item{map}{The acmap data object.}

\item{filename}{Path to the file.}

\item{compress}{Should the file be xz compressed}

\item{pretty}{Should json be output prettily with new lines and indentation}

\item{round_titers}{Should titers be rounded when outputted (this is needed
for acmacs web and lispmds compatibility)}
}
\value{
No return value, called for the side effect of saving the map data
to the file.
}
\description{
Save acmap data to a file. The preferred extension is ".ace", although
the format of the file will be a json file of map data compressed using
'xz' compression.
}
\seealso{
Other functions for working with map data: 
\code{\link{acmap}()},
\code{\link{addOptimization}()},
\code{\link{agReactivityAdjustments}()},
\code{\link{as.json}()},
\code{\link{edit_agNames}()},
\code{\link{edit_srNames}()},
\code{\link{keepBestOptimization}()},
\code{\link{keepSingleOptimization}()},
\code{\link{layerNames}()},
\code{\link{orderPoints}},
\code{\link{read.acmap}()},
\code{\link{read.titerTable}()},
\code{\link{removePoints}},
\code{\link{save.coords}()},
\code{\link{save.titerTable}()},
\code{\link{subsetCommonPoints}},
\code{\link{subsetMap}()}
}
\concept{functions for working with map data}
