% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rapfunc.R
\name{gwascat.download}
\alias{gwascat.download}
\title{Retrieve GWAS summary datasets from GWAS catalog
'\code{gwascat.download} takes a PMID from the user and downloads the associated summary statistics datasets published in GWAS catalog}
\usage{
gwascat.download(ID, filenum = NULL, hm_only = TRUE)
}
\arguments{
\item{ID}{a numeric. A PubMed ID (PMID) reference number from a GWAS paper.}

\item{filenum}{a numeric. If multiple files are available, which one to choose? If NULL (DEFAULT), R will prompt an interactive prompt, asking for the number.}

\item{hm_only}{a logical. Should GWAS catalog harmonised columns be retained?}
}
\value{
a data.table containing the dataset.
}
\description{
This function, takes PUBMED ids as an input, searches at the GWAS catalog
for harmonised datasets associated to that, interactively asking the
user to choose if there are more than one, and fetches the dataset.
}
\details{
If multiple files are available for the same study, R will prompt an interactive
dialogue to select a specific file, by number. If you know the number and
prefer to select it automatically, you can provide it using file argument.
}
\examples{

\dontrun{
ds <- gwascat.download(29059683, hm_only = FALSE) # This should work: Michailidou dataset
wrongds <- gwascat.download(01223247236) # This shouldn't work: The Empress pub phone number
}

}
\author{
Guillermo Reales
}
