burden.subscores <- function(x, NullObject, genomic.region = x@snps$genomic.region, SubRegion = x@snps$SubRegion, burden.function = WSS, maf.threshold = 0.5, get.effect.size = FALSE, alpha = 0.05, cores = 10, verbose = TRUE){
  #Test if NullObject de bon type
  if("P1" %in% names(NullObject)) stop("'NullObject' has been generated with wrong 'RVAT' in 'NullObject.parameters()'") 
  
  if(missing(x)) x <- NULL
  if(NullObject$pheno.type == "categorical"){
    if(verbose) cat("Categorical phenotype \n")
    res <- burden.mlogit.subscores(x = x, NullObject = NullObject, genomic.region = genomic.region, SubRegion = SubRegion, burden.function = burden.function, maf.threshold = maf.threshold, get.effect.size = get.effect.size, alpha = alpha, cores = cores)
  }
  if(NullObject$pheno.type == "continuous"){
    if(verbose) cat("Continuous phenotype \n")
    res <- burden.continuous.subscores(x = x, NullObject = NullObject, genomic.region = genomic.region, SubRegion = SubRegion, burden.function = burden.function, maf.threshold = maf.threshold, get.effect.size = get.effect.size, alpha = alpha, cores = cores)
  }
  return(res)
}
