% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvt_wsc.R
\name{rvn_rvt_wsc}
\alias{rvn_rvt_wsc}
\title{EC Streamgauge File Conversion}
\usage{
rvn_rvt_wsc(
  ff,
  subIDs,
  prd = NULL,
  stnNames = NULL,
  write_redirect = FALSE,
  flip_number = FALSE,
  filename = NULL
)
}
\arguments{
\item{ff}{WSC flow file in csv format}

\item{subIDs}{vector of subbasin IDs to correspond to the stations in ff}

\item{prd}{(optional) data period to use in .rvt file}

\item{stnNames}{(optional) character vector of alternative station names to
use}

\item{write_redirect}{(optional) write the :RedirectToFile commands in a
separate .rvt file}

\item{flip_number}{(optional) put the subID first in the .rvt filename}

\item{filename}{specified name of file(s) to write to (optional)}
}
\value{
\item{TRUE}{return TRUE if the function is executed properly}
}
\description{
rvn_rvt_wsc converts Environment Canada historical streamgauge data,
downloaded from the Water Survey Canada, into .rvt format files usable in
Raven.
}
\details{
This function takes a single WSC flow file and converts the flow data for
each station in the file into .rvt formatted files for a Raven model. If
multiple stations exist in the .csv file,

The file should be downloaded in a .csv Date-Data format with missing days
included. The download website is linked below. Any level data will be
ignored, although can be included in the file for stations with flow and
level data. If no data is found for a given station, an error will be
reported.

subIDs is required and should correspond to the subID to be used in the .rvt
file for each station in the ff file, in the order in which it will be read
in. If the subbasin is currently unknown, please supply a placeholder value.

prd is used by the xts formatted-data to restrict the data reported in .rvt
files, for each station, to this period. The prd should be defined in
"YYYY-MM-DD/YYYY-MM-DD" string format. If the period supplied results in an
empty time series (i.e. non-overlapping time periods), an error will be
thrown.

stnNames is an optional character vector to replace the EC station codes
found in the .csv file. If supplied, the vector must be of the same length
as the number of stations supplied and the subIDs vector. If not supplied,
the EC station codes will be used. Note that this does not impact model
function, only filename readability and station recognition.

write_redirect will print out the :RedirectToFile commands in a separate
file called, "flow_stn_redirect_text.rvt". These commands can be copied into
the main model's .rvt file to redirect to the produced time series files.

flip_number is a useful option to place the subID first in the filename.
This is often cleaner for organizing files in a folder, since the
alphabeticized order is not dependent on the station name, and the observed
files will be in one set.

The function will write to name generated from the station name(s), otherwise
the .rvt filename may be specified with the filename argument (full path to
the filename, including .rvt extension). If multiple stations are provided,
the filename argument may be a vector of filenames.
}
\examples{
ff = system.file("extdata",'Daily__Oct-1-2020_08_20_52PM.csv', package="RavenR")
rvn_rvt_wsc(ff,subIDs=c(6), filename=file.path(tempdir(), "stn_02GB001.rvt"))

}
\seealso{
\code{\link{rvn_annual_peak_event}} to consider the timing of peak
events

Download EC streamgauge data from
\href{https://wateroffice.ec.gc.ca/search/historical_e.html}{WSC Historical
Data}.
}
