% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvh_summarize.R
\name{rvn_rvh_summarize}
\alias{rvn_rvh_summarize}
\title{Summarize RVH object}
\usage{
rvn_rvh_summarize(rvh = NULL, return_list = TRUE)
}
\arguments{
\item{rvh}{rvh object as returned by \code{\link{rvn_rvh_read}} or \code{\link{rvn_rvh_query}}}

\item{return_list}{boolean whether the to return the summary list object, if \code{FALSE} only \code{TRUE} is returned (default \code{TRUE})}
}
\value{
Returns \code{TRUE} if the parameter \code{return_list} is \code{FALSE}, otherwise returns a list with multiple items:
 \item{total_subbasin_area}{total subbasin area, computed as the sum of all areas in \code{rvh$SBtable$Area}}
 \item{num_subbasins}{total number of subbasins}
 \item{num_hrus}{total number of HRUs}
 \item{num_unique_hrus}{total number of unique HRUs, i.e. HRUs with unique combination of LandUse, Vegetation, Soil Profile, and Terrain/Aquifer if relevant (see details)}
 \item{hru_summary_landuse}{a dataframe summarizing the RVH object by LandUse class}
 \item{hru_summary_vegetation}{a dataframe summarizing the RVH object by Vegetation class}
 \item{hru_summary_soilprofile}{a dataframe summarizing the RVH object by Soil Profile}
 \item{hru_summary_terrain}{a dataframe summarizing the RVH object by Terrain class}
 \item{hru_summary_aquifer}{a dataframe summarizing the RVH object by Aquifer class}
 \item{hru_summary_general}{a dataframe summarizing the RVH object by LandUse, Vegetation, Soil Profile, and Terrain/Aquifer if relevant (see details)}
 \item{dom_landuse}{dominant LandUse class by total area}
 \item{dom_landuse_ratio}{ratio of the total area of dominant LandUse class by total subbasin area}
 \item{dom_vegetation}{dominant Vegetation class by total area}
 \item{dom_vegetation_ratio}{ratio of the total area of dominant Vegetation class by total subbasin area}
 \item{dom_soilprofile}{dominant Soil Profile by total area}
 \item{dom_soilprofile_ratio}{ratio of the total area of dominant Soil Profile by total subbasin area}
 \item{dom_terrain}{dominant Terrain class by total area (NULL if no Terrain classes defined)}
 \item{dom_terrain_ratio}{ratio of the total area of dominant Terrain class by total subbasin area (NA if no Terrain classes defined)}
 \item{dom_aquifer}{dominant Aquifer class by total area (NULL if no Aquifer classes defined)}
 \item{dom_aquifer_ratio}{ratio of the total area of dominant Aquifer class by total subbasin area (NA if no Aquifer classes defined)}
}
\description{
Summarizes the RVH object provided in a number of useful ways, and returns a list with the summarized information.
}
\details{
The total subbasin area is the total area of all subbasins in the RVH object. If there are multiple outlets
in the model, or additional subbasin information that is not part of the model domain, this will be counted in the total
area and other summary diagnostics. Consider using \code{\link{rvn_rvh_query}} to isolate portions of the domain
in such instances.

Information for dominant Terrain and Aquifer classes is also returned, but only if there are Terrain or Aquifer
classes respectively other than '[NONE]'. The number of unique HRUs include Terrain and Aquifer classes in the consideration of unique HRUs if
there are instances of classes other than '[NONE]' for these classes.
}
\examples{
# load example rvh file
nith <- system.file("extdata","Nith.rvh",package = "RavenR")
rvh <- rvn_rvh_read(nith)

# summarize rvh
rvn_rvh_summarize(rvh, return_list=FALSE)

# query of HRUs upstream of basin 39, then summarize
rvh \%>\%
  rvn_rvh_query(subbasinID=39, condition="upstream_of") \%>\%
  rvn_rvh_summarize(return_list=FALSE)

}
\seealso{
\code{\link{rvn_rvh_read}} to read a Raven RVH file into R
\code{\link{rvn_rvh_query}} to query the RVH file prior to other operations, such as summarizing)
}
