% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzyCMeans.R
\name{fuzzy.CM}
\alias{fuzzy.CM}
\title{Fuzzy C-Means}
\usage{
fuzzy.CM(X, K = 2, m = 2, max.iteration = 100, threshold = 10^-5,
  RandomNumber = 0)
}
\arguments{
\item{X}{data frame n x p}

\item{K}{specific number of cluster (must be >1)}

\item{m}{fuzzifier / degree of fuzziness}

\item{max.iteration}{maximum iteration to convergence}

\item{threshold}{threshold of convergence}

\item{RandomNumber}{specific seed}
}
\value{
func.obj objective function that calculated.

U matrix n x K consist fuzzy membership matrix

V matrix K x p consist fuzzy centroid

D matrix n x K consist distance of data to centroid that calculated

Clust.desc cluster description (dataset with additional column of cluster label)
}
\description{
This function used to perform Fuzzy C-Means of X dataset.
}
\details{
This function perform Fuzzy C-Means algorithm by Bezdek (1981).
Fuzzy C-Means is one of fuzzy clustering methods to clustering dataset
become K cluster. Number of cluster (K) must be greater than 1. To control the overlaping
or fuzziness of clustering, parameter m must be specified.
Maximum iteration and threshold is specific number for convergencing the cluster.
Random Number is number that will be used for seeding to firstly generate fuzzy membership matrix.

Clustering will produce fuzzy membership matrix (U) and fuzzy cluster centroid (V).
The greatest value of membership on data point will determine cluster label.
Centroid or cluster center can be use to interpret the cluster. Both membership and centroid produced by
calculating mathematical distance. Fuzzy C-Means calculate distance with Euclideans norm. So it can be said that cluster
will have sperichal shape of geometry.
}
\examples{
library(RcmdrPlugin.FuzzyClust)
data(iris)
fuzzy.CM(X=iris[,1:4],K = 3,m = 2,RandomNumber = 1234)->cl
}
\references{
Balasko, B., Abonyi, J., & Feil, B. (2002). Fuzzy Clustering and Data Analysis Toolbox: For Use with Matlab. Veszprem, Hungary.

Gustafson, D. E., & Kessel, W. C. (1978). Fuzzy Clustering With A Fuzzy Covariance Matrix. 761-766.

Bezdek, J. C., Ehrlich, R., & Full, W. (1984). FCM: The Fuzzy C-Means Clustering Algorithm. Computers and Geosciences Vol 10, 191-203
}

