% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb_fetch.R
\name{cdb_fetch}
\alias{cdb_fetch}
\title{Fetch the COM(P)ADRE database from compadre-db.org or a local file}
\usage{
cdb_fetch(cdb, flag = FALSE)
}
\arguments{
\item{cdb}{Either "comadre" or "compadre" (case insensitive) to fetch the
most recent database from \url{https://compadre-db.org}, or a path to an
existing COMPADRE database (i.e. .RData file) stored on the local machine.}

\item{flag}{Logical argument where `TRUE` will automatically run
\link{cdb_flag} to add logical columns to the metadata to flag potential
problems in the matrix population models. Default is `FALSE`.}
}
\value{
A CompadreDB object
}
\description{
Fetches the current version of a COM(P)ADRE database from
\url{https://compadre-db.org}, or load any version stored in a local .RData
file.
}
\examples{
\dontrun{
#Download direct from the COMPADRE website
compadre <- cdb_fetch("compadre")

#using file path to downloaded data
compadre <- cdb_fetch("data/COMPADRE_v.5.0.1.RData") 
}
}
\seealso{
Other data acquisition: 
\code{\link{cdb_build_cdb}()},
\code{\link{cdb_metadata}()}
}
\author{
Patrick M. Barks <patrick.barks@gmail.com>

Owen R. Jones <jones@biology.sdu.dk>
}
\concept{data acquisition}
