# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Retrieve all configuration settings
#'
#' This functions returns all configuration settings which can be queried
#' in a data.frame object. The system-level functions \code{sysconf},
#' \code{pathconf} and \code{confstr} provide all the underlying information.
#'
#' @title Return all System Configuration Settings
#' @param path An optional character object specifying a path. Default is the 
#' current directory.
#' @return A data.frame with three colums for key, value and (source) type.
#' Not all keys return a value; in those cases an empty string is returned.
#' Type is one of \code{path}, \code{sys} and \code{conf} and signals how the
#' value was obtained.
#' @author Dirk Eddelbuettel
#' @examples
#' head(getAll(), 30)
#' subset(getAll(), type=="path")
getAll <- function(path = ".") {
    .Call('RcppGetconf_getAll', PACKAGE = 'RcppGetconf', path)
}

