% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flags.R
\name{flags}
\alias{flags}
\alias{RcppParallelLibs}
\alias{LdFlags}
\alias{CxxFlags}
\title{Compilation flags for RcppParallel}
\usage{
CxxFlags()

LdFlags()

RcppParallelLibs()
}
\value{
Returns \code{NULL}, invisibly. These functions are called for
  their side effects (writing the associated flags to stdout).
}
\description{
Output the compiler or linker flags required to build against RcppParallel.
}
\details{
These functions are typically called from \code{Makevars} as follows:

```
PKG_LIBS += $(shell "${R_HOME}/bin/Rscript" -e "RcppParallel::LdFlags()")
```

On Windows, the flags ensure that the package links with the built-in TBB
library. On Linux and macOS, the output is empty, because TBB is loaded
dynamically.

To ensure portability, load \pkg{RcppParallel} before loading
your package, e.g. by including \code{importFrom(RcppParallel,
RcppParallelLibs)} in your \code{NAMESPACE} file. See
\url{https://github.com/RcppCore/RcppParallel/issues/129} for details.
}
