% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcssWrappers.R
\name{contour}
\alias{contour}
\title{Draw a styled contour}
\usage{
contour(
  x = seq(0, 1, length.out = nrow(z)),
  y = seq(0, 1, length.out = ncol(z)),
  z,
  Rcss = "default",
  Rcssclass = NULL,
  ...
)
}
\arguments{
\item{x}{numeric vector; locations of grid lines}

\item{y}{numeric vector; locations of grid lines}

\item{z}{matrix of values}

\item{Rcss}{style sheet object. Leave "default" to use a style
defined via RcssSetDefaultStyle()}

\item{Rcssclass}{character, style class}

\item{...}{Further parameters, see documentation of graphics::contour}
}
\description{
This is a wrapper for R's contour function.
See R's documentation for graphics::contour for further details.
}
\examples{

# draw a complete contour plot
dataset <- outer(1:10, 1:10)
contour(z=dataset)

}
