\name{roxygen_and_build}
\alias{rab}
\alias{roxygen_and_build}
\title{Roxygenize a package, clean up and build/check the package}
\usage{
  roxygen_and_build(pkg, roxygen.dir = pkg, build = TRUE,
  install = FALSE, check = FALSE, check.opts = "",
  remove.check = TRUE, reformat = TRUE, ...)

  rab(pkg, roxygen.dir = pkg, build = TRUE, install =
  FALSE, check = FALSE, check.opts = "", remove.check =
  TRUE, reformat = TRUE, ...)
}
\arguments{
  \item{pkg}{the root directory of the source package}

  \item{roxygen.dir}{the directory for the roxygenized
  package (by default it is the same as \code{pkg})}

  \item{build}{whether to build the package}

  \item{install}{whether to install the package}

  \item{check}{whether to check the package}

  \item{check.opts}{options to check the package (e.g.
  \code{"--no-examples"})}

  \item{remove.check}{whether to remove the directory
  generated by \command{R CMD check}}

  \item{reformat}{whether to reformat the examples code;
  see \code{\link{reformat_code}}}

  \item{...}{other arguments passed to
  \code{\link[roxygen2]{roxygenize}}}
}
\value{
  \code{NULL}
}
\description{
  After the source package is roxygenized, this function
  will build the package. Optionally it also installs or
  checks the package, reformats the code in the examples
  section. Note \code{\link{rab}} is an alias of
  \code{\link{roxygen_and_build}}.
}
\examples{\dontrun{

roxygen_and_build("Rd2roxygen", install = TRUE)
## or simply
rab("Rd2roxygen", install = TRUE)
}}
\author{
  Yihui Xie <\url{http://yihui.name}>
}

