% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_boxcount.R
\name{est.boxcount}
\alias{est.boxcount}
\title{Box-counting dimension}
\usage{
est.boxcount(X, nlevel = 50, show = FALSE)
}
\arguments{
\item{X}{an \code{(n-by-p)} matrix or data frame whose rows are observations.}

\item{nlevel}{the number of \code{r} (radius) to be tested.}

\item{show}{a logical; \code{FALSE} for not showing visually, \code{TRUE} otherwise.}
}
\value{
a named data frame containing \describe{
\item{r}{a vector of radius used.}
\item{Nr}{a vector of boxes counted for each corresponding \code{r}.}
}
}
\description{
Box-counting dimension, also known as Minkowski-Bouligand dimension, is a popular way of figuring out
the fractal dimension of a set in a Euclidean space. Its idea is to measure the number of boxes
required to cover the set repeatedly by decreasing the length of each side of a box. It is defined as
\deqn{dim(S) = \lim \frac{\log N(r)}{\log (1/r)}} as \eqn{r\rightarrow 0}, where \eqn{N(r)} is
the number of boxes counted to cover a given set for each corresponding \eqn{r}.
}
\section{Determining the dimension}{

In this version, no automated method is included due to lots of possibilities for adopting
any types of change point detection methods. Instead, we recommend using \emph{visual}
identification by looking at the slope of the linear part in the middle using either
\code{show=TRUE} flag or plotting as \code{plot(log(1/output$r),log(output$Nr))}.
}

\examples{
\dontrun{
## generate three different dataset
X1 = aux.gensamples(dname="swiss")
X2 = aux.gensamples(dname="ribbon")
X3 = aux.gensamples(dname="twinpeaks")

## visually verify : all should have approximate slope of 2.
par(mfrow=c(1,3))
est.boxcount(X1,show=TRUE)
est.boxcount(X2,show=TRUE)
est.boxcount(X3,show=TRUE)
}

}
\references{
Ott, E. (1988) \emph{Chaos in Dynamical Systems}. Cambridge University Press.
}
\seealso{
\code{\link{est.correlation}}
}
\author{
Kisung You
}
