% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SPC.R
\name{do.spc}
\alias{do.spc}
\title{Supervised Principal Component Analysis}
\usage{
do.spc(X, response, ndim = 2, preprocess = c("center", "whiten",
  "decorrelate"), threshold = 0.1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{response}{a length-\eqn{n} vector of response variable.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is \code{center}. See also \code{\link{aux.preprocess}} for more details.}

\item{threshold}{a threshold value to cut off normalized association between covariates and response.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Unlike original principal component analysis (\code{\link{do.pca}}), this algorithm implements
a supervised version using response information for feature selection. For each feature/column,
its normalized association with \code{response} variable is computed and the features with
large magnitude beyond \code{threshold} are selected. From the selected submatrix,
regular PCA is applied for dimension reduction.
}
\examples{
\dontrun{
## generate swiss roll with auxiliary dimensions
## it follows reference example from LSIR paper.
n = 123
theta = runif(n)
h     = runif(n)
t     = (1+2*theta)*(3*pi/2)
X     = array(0,c(n,10))
X[,1] = t*cos(t)
X[,2] = 21*h
X[,3] = t*sin(t)
X[,4:10] = matrix(runif(7*n), nrow=n)

## corresponding response vector
y = sin(5*pi*theta)+(runif(n)*sqrt(0.1))

## try different threshold values
out1 = do.spc(X, y, threshold=0.5)
out2 = do.spc(X, y, threshold=1)
out3 = do.spc(X, y, threshold=2)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="SPC::threshold=0.5")
plot(out2$Y[,1], out2$Y[,2], main="SPC::threshold=1")
plot(out3$Y[,1], out3$Y[,2], main="SPC::threshold=2")
}

}
\references{
\insertRef{bair_prediction_2006}{Rdimtools}
}
\author{
Kisung You
}
