% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_boxcount.R
\name{est.boxcount}
\alias{est.boxcount}
\title{Box-counting Dimension}
\usage{
est.boxcount(X, nlevel = 50, cut = c(0.1, 0.9))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{nlevel}{the number of \code{r} (radius) to be tested.}

\item{cut}{a vector of ratios for computing estimated dimension in \eqn{(0,1)}.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated dimension using \code{cut} ratios.}
\item{r}{a vector of radius used.}
\item{Nr}{a vector of boxes counted for each corresponding \code{r}.}
}
}
\description{
Box-counting dimension, also known as Minkowski-Bouligand dimension, is a popular way of figuring out
the fractal dimension of a set in a Euclidean space. Its idea is to measure the number of boxes
required to cover the set repeatedly by decreasing the length of each side of a box. It is defined as
\deqn{dim(S) = \lim \frac{\log N(r)}{\log (1/r)}} as \eqn{r\rightarrow 0}, where \eqn{N(r)} is
the number of boxes counted to cover a given set for each corresponding \eqn{r}.
}
\section{Determining the dimension}{

Even though we could use arbitrary \code{cut} to compute estimated dimension, it is also possible to
use visual inspection. According to the theory, if the function returns an \code{output}, we can plot
\code{plot(log(1/output$r),log(output$Nr))} and use the linear slope in the middle as desired dimension of data.
}

\section{Automatic choice of \eqn{r}}{

The least value for radius \eqn{r} must have non-degenerate counts, while the maximal value should be the
maximum distance among all pairs of data points across all coordinates. \code{nlevel} controls the number of interim points
in a log-equidistant manner.
}

\examples{
\donttest{
## generate three different dataset
X1 = aux.gensamples(dname="swiss")
X2 = aux.gensamples(dname="ribbon")
X3 = aux.gensamples(dname="twinpeaks")

## compute boxcount dimension
out1 = est.boxcount(X1)
out2 = est.boxcount(X2)
out3 = est.boxcount(X3)

## visually verify : all should have approximate slope of 2.
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(log(1/out1$r), log(out1$Nr), main="swiss roll")
plot(log(1/out2$r), log(out2$Nr), main="ribbon")
plot(log(1/out3$r), log(out3$Nr), main="twinpeaks")
par(opar)
}

}
\references{
\insertRef{hentschel_infinite_1983}{Rdimtools}

\insertRef{ott_chaos_2002}{Rdimtools}
}
\seealso{
\code{\link{est.correlation}}
}
\author{
Kisung You
}
