% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v_nonlinear_LAMP.R
\name{do.lamp}
\alias{do.lamp}
\title{Local Affine Multidimensional Projection}
\usage{
do.lamp(X, ndim = 2)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Local Affine Mulditimensional Projection (\emph{LAMP}) can be considered as
a nonlinear method even though each datum is projected using locally estimated
affine mapping. It first finds a low-dimensional embedding for control points
and then locates the rest data using affine mapping. We use \eqn{\sqrt{n}} number
of data as controls and Stochastic Neighborhood Embedding is applied as an
initial projection of control set. Note that this belongs to the method for
visualization so projection onto \eqn{\mathbf{R}^2} is suggested for use.
}
\examples{
\donttest{
## load iris data
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

## let's compare with PCA
out1 <- do.pca(X, ndim=2)      # PCA
out2 <- do.lamp(X, ndim=2)     # LAMP

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(out1$Y, pch=19, col=label, main="PCA")
plot(out2$Y, pch=19, col=label, main="LAMP")
par(opar)
}

}
\references{
\insertRef{joia_local_2011}{Rdimtools}
}
\seealso{
\code{\link{do.sne}}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
