% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.dfunc.R
\name{AIC.dfunc}
\alias{AIC.dfunc}
\title{AIC.dfunc - AIC-related fit statistics for detection functions}
\usage{
\method{AIC}{dfunc}(object, ..., criterion = "AICc")
}
\arguments{
\item{object}{An Rdistance model frame or fitted distance function,
normally produced by a call to \code{\link{dfuncEstim}}.}

\item{...}{Included for compatibility with generic \code{predict} methods.}

\item{criterion}{String specifying the criterion to compute. Either 
"AICc", "AIC", or "BIC".}
}
\value{
A scalar, the requested fit statistic for \code{object}.
}
\description{
Computes AICc, AIC, or BIC for estimated distance functions.
}
\details{
Regular Akaike's information criterion 
  (\url{https://en.wikipedia.org/wiki/Akaike_information_criterion}) (\eqn{AIC}) is 
  \deqn{AIC = LL + 2p,}{AIC = (LL) + 2p,}
  where \eqn{LL} is the maximized value of the log likelihood 
  (the minimized value of the negative log 
  likelihood) and \eqn{p} is the 
  number of coefficients estimated in the detection function.  For 
  \code{dfunc} objects, \eqn{AIC} = \code{obj$loglik + 2*length(coef(obj))}.  
  
  A correction 
  for small sample size, \eqn{AIC_c}{AICc}, is 
  \deqn{AIC_c = LL + 2p + \frac{2p(p+1)}{n-p-1},}{AIC_c = LL + 2p + (2p(p+1))/(n-p-1),} 
  where \eqn{n} is sample 
  size or number of detected groups for distance analyses.  By default, this function 
  computes \eqn{AIC_c}{AICc}.   \eqn{AIC_c}{AICc} converges quickly to \eqn{AIC} 
  as \eqn{n} increases.
  
  The Bayesian Information Criterion (BIC) is
  \deqn{BIC = LL + log(n)p,}{BIC = (LL) + log(n)p}.
}
\examples{
data(sparrowDf)
dfunc <- sparrowDf |> dfuncEstim(dist~1)
  
# Fit statistics
AIC(dfunc)  # AICc
AIC(dfunc, criterion="AIC")  # AIC
AIC(dfunc, criterion="BIC")  # BIC

}
\references{
Burnham, K. P., and D. R. Anderson, 2002. 
\emph{Model selection and multi-model inference: 
   A practical information-theoretic approach, Second ed.} 
   Springer-Verlag. ISBN 0-387-95364-7.
  
  McQuarrie, A. D. R., and Tsai, C.-L., 1998. \emph{Regression and 
  time series model selection.} 
  World Scientific. ISBN 981023242X
}
\seealso{
\code{\link{coef}}, \code{\link{dfuncEstim}}
}
\keyword{model}
