% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rdrools.R
\name{rulesSessionDrl}
\alias{rulesSessionDrl}
\title{Creates a session of the rules engine}
\usage{
rulesSessionDrl(rules, input.columns, output.columns)
}
\arguments{
\item{rules}{a character vector consisting of lines read from a rules file of format \emph{.drl}
(Drools rules file). This character vector is eventually collapsed into a character vector of length 1, 
so the way you read the file could potentially be just about anything}

\item{input.columns}{a character vector of a set of input column, for example. 
\code{input.columns<-c('name', 'class', 'grade', 'email')}}

\item{output.columns}{a character vector of a set of expected output columns, for example.
\code{output.columns<-c('address', 'subject', 'body')}}
}
\value{
rules.session.object Returns a session to the rules engine
}
\description{
The rulesSession creates a session that interfaces between R and the Drools engine. 
The session is utilized by the runRulesDrl function for executing a data frame against a set of rules
}
\details{
An active drools rules session. This promotes re-usability of a session, i.e. you can 
utilize the same session repetitively for different data sets of the same format.
}
\note{
Please have a look at the examples provided in the 'examples' section of the 
\code{\link{Rdrools}}. A sample data set and a set of rules have been supplied help you 
understand the package usage.
}
\examples{
library(Rdrools)
data(class)
data(rules)
input.columns<-c('name', 'class', 'grade', 'email')
output.columns<-c('address', 'subject', 'body')
rulesSession<-rulesSessionDrl(rules, input.columns, output.columns)
output.df<-runRulesDrl(rulesSession, class)
}
\seealso{
\code{\link{runRulesDrl}}, \code{\link{Rdrools}}

Other Interface Functions to Drools: \code{\link{executeRulesOnDataset}},
  \code{\link{runRulesDrl}}
}
\author{
Ashwin Raaghav <ashwin.raaghav@mu-sigma.com>

SMS Chauhan <sms.chauhan@mu-sigma.com>
}
