% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rdrools.R
\name{runRulesDrl}
\alias{runRulesDrl}
\title{Apply a set of rule transformations to a data frame}
\usage{
runRulesDrl(rules.session, input.df)
}
\arguments{
\item{rules.session}{a session of the rules engine created using the \code{\link{rulesSessionDrl}} function}

\item{input.df}{a data frame consisting of a set of rows you wish to transform, and columns you 
wish to use in the transformation}
}
\value{
output.df a data frame which is the result of transformations applied to the input data 
frame(\code{input.df}), the columns being the list provided through the \code{output.columns} 
parameter in \code{\link{rulesSessionDrl}}
}
\description{
This function is the core of the Rdrools package. Rules are applied on an input data frame 
and the results are returned as the output of the function. The columns on which the rules need to be 
applied have to be provided explicitly. Additionally, the new columns that would be created based on
the rules have to be provided explicitly as well. The rules engine picks up a row from the data frame,
 applies the transformation to it based on rules provided and saves the result in an output data frame.
}
\details{
If you are not familiar with the Drools file format, please have a look at the references 
provided in the \code{\link{Rdrools}}. More details on how conflicting rules are resolved 
using either salience or the Reete algorithm are also present in the references.

\strong{Transformation policy} Transformations are applied row by row, iteratively. That is to say, 
all inputs required for a rule transformation should be present in columns as a part of that row 
itself. Each row should be considered 
independent of another; all input values required for a
transformation should be available in that row itself. The expectation from rules engines are 
often misplaced.

\strong{Column Mismatch} Please make sure that the list of output columns provided through the 
\code{output.columns} parameter is exhaustive. Any additional column which is created through the 
rules transformation but is not present in the list would inhibit proper functioning. In most cases,
an error should be thrown.
}
\examples{
library(Rdrools)
data(class)
data(rules)
input.columns<-c('name', 'class', 'grade', 'email')
output.columns<-c('address', 'subject', 'body')
rulesSession<-rulesSessionDrl(rules, input.columns, output.columns)
output.df<-runRulesDrl(rulesSession, class)
}
\seealso{
\code{\link{runRulesDrl}}, \code{\link{Rdrools}}

Other Interface Functions to Drools: \code{\link{executeRulesOnDataset}},
  \code{\link{rulesSessionDrl}}
}
\author{
Ashwin Raaghav <ashwin.raaghav@mu-sigma.com>

SMS Chauhan <sms.chauhan@mu-sigma.com>
}
