% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSQLDataModel.R
\name{read_SQL_data_model}
\alias{read_SQL_data_model}
\alias{readSQLDataModel}
\title{Read a data model from an SQL file from the MySQL Workbench}
\usage{
read_SQL_data_model(f, typeRef = "MySQLWB", mysqlcomments = TRUE)

readSQLDataModel(...)
}
\arguments{
\item{f}{the SQL file to read}

\item{typeRef}{the reference for type conversion
(Default: "MySQLWB"; see \code{\link[=list_type_ref]{list_type_ref()}})}

\item{mysqlcomments}{if MySQL comments (starting with #) should be removed
(Default: TRUE)}

\item{...}{params for \code{read_SQL_data_model}}
}
\value{
A \link{RelDataModel} object
}
\description{
Read a data model from an SQL file from the MySQL Workbench
}
\details{
Database, table and field names should be surrounded by "`".
}
\section{Functions}{
\itemize{
\item \code{readSQLDataModel}: Deprecated version of read_SQL_data_model
}}

\examples{
## Read the model ----
hpo_from_sql <- read_SQL_data_model(
   system.file("examples/HPO-model.sql", package="ReDaMoR")
)
## Confront to data ----
confrontation_report <- confront_data(
   hpo_from_sql,
   path=list.files(
      system.file("examples/HPO-subset", package="ReDaMoR"),
      full.names=TRUE
   ),
   returnData=TRUE
)
}
