% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/P_regression.test.R
\name{P_regression.test}
\alias{P_regression.test}
\title{Regression test on record probabilities}
\usage{
P_regression.test(XM_T, record = c("upper", "lower"))
}
\arguments{
\item{XM_T}{A numeric vector, matrix (or data frame).}

\item{record}{A character string indicating the type of records to be 
calculated, "upper" or "lower".}
}
\value{
A \code{"htest"} object with elements:
  \item{null.value}{Value of \eqn{\beta_0} and \eqn{\beta_1} 
    under the null hypothesis.}
  \item{alternative}{Character string indicating the type of alternative
    hypothesis (two-sided).}
  \item{method}{A character string indicating the type of test performed.}
  \item{estimate}{Value of \eqn{\hat \beta_0} and \eqn{\hat \beta_1}.}
  \item{data.name}{A character string giving the name of the data.}
  \item{statistic}{Value of the F statistic.}
  \item{parameters}{Degrees of freedom of the F statistic.}
  \item{p.value}{P-value.}
}
\description{
This function performs a test based on a regression on the
  record probabilities \eqn{p_t} to study the hypothesis of the classical 
  record model.
}
\details{
The null hypothesis of this regression test is that in all the 
  vectors (columns in matrix \code{XM_T}), the probability of record at time
  \eqn{t} is \eqn{1/t}, so that \eqn{t p_t = 1}. Then, hypothesis 
  \eqn{H_0:\,p_t = 1/t}, \eqn{t=2, ..., T} is equivalent to 
  \eqn{H_0:\,\beta_0 = 1, \, \beta_1 = 0} where \eqn{\beta_0} and 
  \eqn{\beta_1} are the coefficients of the regression model 
  \eqn{t p_t=\beta_0 + \beta_1 t}. The  model has to be estimated by 
  weighted least squares since the response is heteroskedastic.

  The F statistic is used to compare the regression model under the null 
  hypothesis and a linear regression model with no restriction (the 
  alterantive hypothesis is then that \eqn{t p_t} is a linear function of 
  time). This alternative hypothesis may be reasonable in many real 
  examples, but not always.
}
\examples{
P_regression.test(ZaragozaSeries)
}
\seealso{
\code{\link{P_exactPB.test}}, \code{\link{P_chisq.test}}, 
  \code{\link{P_regression.plot}}
}
\author{
Jorge Castillo-Mateo
}
