\name{Renvlp-package}
\alias{Revnlp-package}
\docType{package}

\title{
Computing Envelope Estimators
}

\description{
This package contains functions for estimating envelope models including response envelopes, partial response envelopes, envelopes in the predictor space, heteroscedastic envelopes, simultaneous envelopes, scaled response envelopes, scaled envelopes in the predictor space, groupwise envelopes, weighted envelopes, envelopes in logistic regression, envelopes in poisson regression, envelopes in function-on-function linear regression, envelope-based Partial Partial Least Squares,  envelopes with non-constant error covariance, envelopes with t-distributed errors, reduced rank envelopes and reduced rank envelopes with non-constant error covariance.
}

\details{
\tabular{ll}{
Package: \tab Renvlp\cr
Type: \tab Package\cr
Version: \tab 3.4\cr
Date: \tab 2023-04-16\cr
License: \tab GPL-2\cr
Imports: \tab Rsolnp, orthogonalsplinebasis, pls, matrixcalc, Matrix\cr
Suggests: \tab Mass, stats\cr
}
}

\author{
  Minji Lee and Zhihua Su.
  
  Maintainer: Minji Lee <minjilee101@gmail.com>
}

\references{
Cook, R. D., Forzani, L. and Su, Z. (2016) A Note on Fast Envelope Estimation. Journal of Multivariate Analysis. 150, 42-54.	
	
Cook, R. D., Li, B. and Chiaromente, F. (2010). Envelope Models for Parsimonious and Efficient Multivariate Linear Regression (with discussion). Statist. Sinica 20, 927- 1010.

Su, Z. and Cook, R.D. (2011). Partial envelopes for efficient estimation in multivariate linear regression. Biometrika 98, 133 - 146.

Cook, R. D., Helland, I. S. and Su, Z. (2013). Envelopes and Partial Least Squares Re-
gression. Journal of the Royal Statistical Society: Series B 75, 851 - 877.

Su, Z. and Cook, R.D. (2013). Estimation of Multivariate Means with Heteroscedastic Error Using Envelope Models. Statistica Sinica, 23, 213-230.

Cook, R. D., Zhang, X. (2015). Simultaneous Envelopes for Multivariate Linear Regression. Technometrics 57, 11 - 25.

Cook, R. D., Su, Z. (2013). Scaled Envelopes: scale Invariant and Efficient Estimation in Multivariate Linear Regression. Biometrika 100, 939 - 954.

Cook, R. D., Su, Z. (2016). Scaled Predictor Envelopes and Partial Least Squares Regression. Technometrics 58, 155 - 165.

Park, Y., Su, Z. and Zhu, H. (2017)  Groupwise envelope models for Imaging Genetic Analysis. Biometrics.

Eck, D. J. and Cook, R. D. (2017). Weighted Envelope Estimation to Handle Variability in Model
Selection. Biometrika.

Cook, R. D., Zhang, X. (2015). Foundations for Envelope Models and Methods. Journal of the American Statistical Association 110, 599 - 611.

Su, Z., Li, B. and Cook, R. D. (2022+) Envelope model for function-on-function linear regression.

Park, Y., Su, Z. and Chung, D. (2022+)  Envelope-based Partial Partial Least Squares with Application to Cytokine-based Biomarker Analysis for COVID-19. Statistics in Medicine. 

Cook, R. D., Forzani, L. and Zhang, X. (2015). Envelopes and reduced-rank regression.  Biometrika 102, 439-456.

Forzani, L. and Su, Z. (2021). Envelopes for elliptical multivariate linear regression. Statist. Sinica 31, 301-332.
}


