% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levelSceptical.R
\name{levelSceptical}
\alias{levelSceptical}
\title{Computes the replication success level}
\usage{
levelSceptical(
  level,
  c = NA,
  alternative = c("one.sided", "two.sided"),
  type = c("golden", "nominal", "controlled")
)
}
\arguments{
\item{level}{Threshold for the calibrated sceptical p-value.
Default is 0.025.}

\item{c}{The variance ratio. Only required when \code{type = } "controlled".}

\item{alternative}{Specifies if \code{level} is "one.sided" (default) or
 "two.sided". If "one-sided",
then a one-sided replication success level is computed.}

\item{type}{Type of recalibration. Can be either "golden" (default), "nominal" (no recalibration),
 or "controlled". "golden" ensures that for an original study just significant at
the specified \code{level}, replication success is only possible for 
replication effect estimates larger than the original one.
"controlled" ensures exact overall Type-I error control at level \code{level}^2.}
}
\value{
Replication success levels
}
\description{
The replication success level is computed based on the specified
alternative and recalibration type.
}
\details{
\code{levelSceptical} is the vectorized version of
the internal function \code{.levelSceptical_}.
\code{\link[base]{Vectorize}} is used to vectorize the function.
}
\examples{
levelSceptical(level = 0.025, alternative = "one.sided", type = "nominal")
levelSceptical(level = 0.025, alternative = "one.sided", type = "controlled", c = 1)
levelSceptical(level = 0.025, alternative = "one.sided", type = "golden")
}
\references{
Held, L. (2020). A new standard for the analysis and design of replication studies (with discussion).
\emph{Journal of the Royal Statistical Society: Series A (Statistics in Society)}, \bold{183}, 431-448.
\doi{10.1111/rssa.12493}

Held, L. (2020). The harmonic mean chi-squared test to substantiate scientific findings.
\emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, \bold{69}, 697-708.
\doi{10.1111/rssc.12410}

Held, L., Micheloud, C., Pawel, S. (2022). The assessment of replication
success based on relative effect size.
\emph{The Annals of Applied Statistics}, \bold{16}, 706-720.
\doi{10.1214/21-AOAS1502}

Micheloud, C., Balabdaoui, F., Held, L. (2023).
Beyond the two-trials rule: Type-I error control and sample size planning
with the sceptical p-value. \url{https://arxiv.org/abs/2207.00464}
}
\author{
Leonhard Held
}
