/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.lists;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.docx4j.wml.Numbering;
import org.lysis.reporters.lists.DocxListNumberingDefinition;
import org.lysis.reporters.lists.LevelDefinition;

public class ListDefinition {
    private int current_level = 0;
    private int listid;
    private LinkedHashMap<Integer, LevelDefinition> lvlDefinitions = new LinkedHashMap();

    public ListDefinition(int listid) {
        this.listid = listid;
    }

    public void setAbstractNumID(int numid) {
        this.listid = numid;
    }

    public boolean addLevel(double indent_left, double indent_hanging, String textalign, String format, String pattern) {
        if (this.current_level > 8) {
            return false;
        }
        LevelDefinition ld = new LevelDefinition(indent_left, indent_hanging, textalign, format, pattern, this.current_level);
        this.lvlDefinitions.put(this.current_level, ld);
        ++this.current_level;
        return true;
    }

    public Numbering.AbstractNum getDocxAbstractNum() throws Exception {
        DocxListNumberingDefinition lnd = new DocxListNumberingDefinition(this.listid);
        Numbering.AbstractNum abstractNum = lnd.getDocxAbstractNum();
        for (Map.Entry<Integer, LevelDefinition> ent : this.lvlDefinitions.entrySet()) {
            abstractNum.getLvl().add(ent.getValue().getLvl());
        }
        return abstractNum;
    }

    public LevelDefinition getLevelDefintion(int level) {
        return this.lvlDefinitions.get(level - 1);
    }

    public String getCSS(int list_id) {
        Iterator<Map.Entry<Integer, LevelDefinition>> partIterator = this.lvlDefinitions.entrySet().iterator();
        String styles = "";
        while (partIterator.hasNext()) {
            Map.Entry<Integer, LevelDefinition> ent = partIterator.next();
            styles = String.valueOf(styles) + ent.getValue().getHTMLCSS(list_id);
        }
        return styles;
    }

    public String getCounterResets(int list_id) {
        Iterator<Map.Entry<Integer, LevelDefinition>> partIterator = this.lvlDefinitions.entrySet().iterator();
        String counters = "";
        while (partIterator.hasNext()) {
            Map.Entry<Integer, LevelDefinition> ent = partIterator.next();
            counters = String.valueOf(counters) + ent.getValue().getCounterName(list_id) + " ";
        }
        return counters;
    }
}

