/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.graphicaldevices.fonts;

import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;

public class FontMetric {
    private String fontname;
    private Font[] fonts;

    public FontMetric(String fontname, int fontsize) {
        System.setProperty("java.awt.headless", "true");
        this.fontname = fontname;
        this.fonts = new Font[4];
        this.fonts[0] = new Font(this.fontname, 0, fontsize);
        this.fonts[1] = new Font(this.fontname, 1, fontsize);
        this.fonts[2] = new Font(this.fontname, 2, fontsize);
        this.fonts[3] = new Font(this.fontname, 3, fontsize);
    }

    public int[] getWidths(int face) {
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(this.fonts[face]);
        return fm.getWidths();
    }

    public int getWidth(int face, String val) {
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(this.fonts[face]);
        return fm.stringWidth(val);
    }

    public int[] getStr(int face) {
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(this.fonts[face]);
        int[] out = new int[]{fm.getAscent(), fm.getDescent(), fm.getHeight()};
        return out;
    }

    public static String getFontFamily(String fontfamily) {
        System.setProperty("java.awt.headless", "true");
        Font ft = new Font(fontfamily, 0, 12);
        return ft.getFamily();
    }
}

