/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.img;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.pml.Sld;

public class DrawingML
extends DocComponent
implements PPTX4R {
    private String filename;
    private int width;
    private int height;
    private static String pptx_model = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><p:sld xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\" ><p:cSld><p:spTree><p:nvGrpSpPr><p:cNvPr id=\"${id_shape}\" name=\"Plot ${id_shape}\" /><p:cNvGrpSpPr><a:grpSpLocks noResize=\"1\" noUngrp=\"1\" noChangeAspect=\"1\" /></p:cNvGrpSpPr><p:nvPr /></p:nvGrpSpPr><p:grpSpPr><a:xfrm><a:off x=\"0\" y=\"0\" /><a:ext cx=\"0\" cy=\"0\" /><a:chOff x=\"0\" y=\"0\" /><a:chExt cx=\"0\" cy=\"0\" /></a:xfrm></p:grpSpPr><p:grpSp><p:nvGrpSpPr><p:cNvPr id=\"${id_properties}\" name=\"Groupe ${id_properties}\" /><p:cNvGrpSpPr /><p:nvPr /></p:nvGrpSpPr><p:grpSpPr><a:xfrm rot=\"${rot}\"><a:off x=\"${offx}\" y=\"${offy}\" /><a:ext cx=\"${cx}\" cy=\"${cy}\" /><a:chOff x=\"${offx}\" y=\"${offy}\" /><a:chExt cx=\"${cx}\" cy=\"${cy}\" /></a:xfrm></p:grpSpPr>${content}</p:grpSp></p:spTree></p:cSld></p:sld>";
    private static String docx_model = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><w:drawing xmlns:wpc=\"http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas\" xmlns:mc=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:wp14=\"http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:w14=\"http://schemas.microsoft.com/office/word/2010/wordml\" xmlns:w15=\"http://schemas.microsoft.com/office/word/2012/wordml\" xmlns:wpg=\"http://schemas.microsoft.com/office/word/2010/wordprocessingGroup\" xmlns:wpi=\"http://schemas.microsoft.com/office/word/2010/wordprocessingInk\" xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\" xmlns:wps=\"http://schemas.microsoft.com/office/word/2010/wordprocessingShape\" mc:Ignorable=\"w14 w15 wp14\" ><wp:inline distT=\"0\" distB=\"0\" distL=\"0\" distR=\"0\"><wp:extent cx=\"${cx}\" cy=\"${cy}\" /><wp:docPr id=\"${id}\" name=\"Zone de dessin ${id}\" /><wp:cNvGraphicFramePr/><a:graphic xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\"><a:graphicData uri=\"http://schemas.microsoft.com/office/word/2010/wordprocessingGroup\"><wpg:wgp><wpg:cNvGrpSpPr /><wpg:grpSpPr><a:xfrm><a:off x=\"0\" y=\"0\" /><a:ext cx=\"${cx}\" cy=\"${cy}\" /><a:chOff x=\"0\" y=\"0\" /><a:chExt cx=\"${cx}\" cy=\"${cy}\" /></a:xfrm></wpg:grpSpPr>${content}</wpg:wgp></a:graphicData></a:graphic></wp:inline></w:drawing>";

    @Override
    public boolean validateDOCXComponent() {
        if (this.getPPr() == null) {
            return false;
        }
        if (this.getCx() < 0L) {
            return false;
        }
        return this.getCy() >= 0L;
    }

    public DrawingML(String filename) {
        this.filename = filename;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public P get_docx_elt() throws Exception {
        String sCurrentLine;
        String data = "";
        if (!this.validateDOCXComponent()) {
            throw new Exception("class DrawingML: elements need to be set...");
        }
        BufferedReader br = new BufferedReader(new FileReader(this.filename));
        while ((sCurrentLine = br.readLine()) != null) {
            data = String.valueOf(data) + sCurrentLine;
        }
        br.close();
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("cx", String.valueOf(this.getCx()));
        mappings.put("cy", String.valueOf(this.getCy()));
        mappings.put("id", String.valueOf(this.unique_id));
        mappings.put("content", data);
        Drawing o = (Drawing)XmlUtils.unmarshallFromTemplate((String)docx_model, mappings, (JAXBContext)Context.jc, Drawing.class);
        P p = new P();
        R r = new R();
        r.getContent().add(o);
        p.getContent().add(r);
        this.addBookmark(p);
        p.setPPr(this.getPPr());
        return p;
    }

    @Override
    public List<Object> get_pptx_elt() throws Exception {
        String sCurrentLine;
        String data = "";
        if (!this.validatePPTXComponent()) {
            throw new Exception("class DrawingML: elements need to be set...");
        }
        BufferedReader br = new BufferedReader(new FileReader(this.filename));
        while ((sCurrentLine = br.readLine()) != null) {
            data = String.valueOf(data) + sCurrentLine;
        }
        br.close();
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("content", data);
        mappings.put("id_shape", String.valueOf(this.shape_id));
        mappings.put("id_properties", String.valueOf(this.unique_id));
        mappings.put("offx", String.valueOf(this.getOffx()));
        mappings.put("offy", String.valueOf(this.getOffy()));
        mappings.put("cx", String.valueOf(this.getCx()));
        mappings.put("cy", String.valueOf(this.getCy()));
        mappings.put("rot", String.valueOf(this.getRot()));
        Sld o = (Sld)XmlUtils.unmarshallFromTemplate((String)pptx_model, mappings, (JAXBContext)org.pptx4j.jaxb.Context.jcPML, Sld.class);
        return o.getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
    }
}

