/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.formats;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.CTColor;
import org.docx4j.dml.CTPositiveFixedPercentage;
import org.docx4j.dml.CTSRgbColor;
import org.docx4j.dml.CTSolidColorFillProperties;
import org.docx4j.dml.ObjectFactory;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.Color;

public class ColorProperties {
    private int r_;
    private int g_;
    private int b_;
    private int a_;

    public ColorProperties(int r, int g, int b, int a) {
        this.r_ = r;
        this.g_ = g;
        this.b_ = b;
        this.a_ = a;
    }

    private static String gethex(int n) {
        return String.format("%02X", n);
    }

    private String gethexcolorcode() {
        String out = String.valueOf(ColorProperties.gethex(this.r_)) + ColorProperties.gethex(this.g_) + ColorProperties.gethex(this.b_);
        return out;
    }

    public String getHexCode() {
        return "#" + this.gethexcolorcode();
    }

    public String getrgba() {
        double alpha = this.a_;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("#.##", decimalFormatSymbols);
        return "rgba(" + this.r_ + ", " + this.g_ + ", " + this.b_ + ", " + decimalFormat.format(alpha /= 255.0) + ")";
    }

    public CTSolidColorFillProperties getSolidFill() {
        CTSolidColorFillProperties solidfill = new CTSolidColorFillProperties();
        solidfill.setSrgbClr(this.getCTSRgbColor());
        return solidfill;
    }

    public CTColor getCTColor() {
        CTColor prop = new CTColor();
        prop.setSrgbClr(this.getCTSRgbColor());
        return prop;
    }

    private CTSRgbColor getCTSRgbColor() {
        ObjectFactory dmlObjectFactory = new ObjectFactory();
        CTSRgbColor rgb = new CTSRgbColor();
        rgb.setVal(new byte[]{(byte)this.r_, (byte)this.g_, (byte)this.b_});
        CTPositiveFixedPercentage positivefixedpercentage = new CTPositiveFixedPercentage();
        positivefixedpercentage.setVal((int)((double)this.a_ / 255.0 * 100000.0));
        JAXBElement positivefixedpercentageWrapped = dmlObjectFactory.createCTSRgbColorAlpha(positivefixedpercentage);
        rgb.getEGColorTransform().add(positivefixedpercentageWrapped);
        return rgb;
    }

    public CTShd getCT_Shd() {
        CTShd shd = new CTShd();
        shd.setFill(this.gethexcolorcode());
        return shd;
    }

    public Color getColor() {
        Color col = new Color();
        col.setVal(this.gethexcolorcode());
        return col;
    }
}

