/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.apache.commons.lang.StringUtils;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.fonts.foray.font.format.Panose;
import org.docx4j.fonts.microsoft.MicrosoftFonts;
import org.docx4j.fonts.substitutions.FontSubstitutions;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.FontPanose;
import org.docx4j.wml.Fonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BestMatchingMapper
extends Mapper {
    protected static Logger log = LoggerFactory.getLogger(BestMatchingMapper.class);
    private static final HashMap<String, MicrosoftFonts.Font> msFontsFilenames;
    private static final Map<String, FontSubstitutions.Replace> explicitSubstitutionsMap;
    private static final Map<String, PhysicalFont> physicalFontsByKey;
    int lastSeenNumberOfPhysicalFonts = 0;
    public static final int MATCH_THRESHOLD = 30;
    private static final int MATCH_THRESHOLD_INTRA_FAMILY = 4;

    public static final Map<String, MicrosoftFonts.Font> getMsFontsFilenames() {
        return msFontsFilenames;
    }

    private static final void setupMicrosoftFontFilenames() throws Exception {
        JAXBContext msFontsContext = JAXBContext.newInstance((String)"org.docx4j.fonts.microsoft");
        Unmarshaller u = msFontsContext.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        log.info("unmarshalling fonts.microsoft \n\n");
        InputStream is = null;
        is = ResourceUtils.getResource("org/docx4j/fonts/microsoft/MicrosoftFonts.xml");
        MicrosoftFonts msFonts = (MicrosoftFonts)u.unmarshal(is);
        List<MicrosoftFonts.Font> msFontsList = msFonts.getFont();
        for (MicrosoftFonts.Font font : msFontsList) {
            msFontsFilenames.put(font.getName(), font);
        }
    }

    private static void generateKeysForPhysicalFonts() {
        for (Map.Entry<String, PhysicalFont> entry : PhysicalFonts.getPhysicalFonts().entrySet()) {
            physicalFontsByKey.put(BestMatchingMapper.generateFontKey(entry.getKey()), entry.getValue());
        }
    }

    private static String generateFontKey(String fontName) {
        return StringUtils.replaceChars((String)fontName.toLowerCase(), (String)"- ", (String)"");
    }

    private static PhysicalFont getPhysicalFontByKey(String key) {
        return physicalFontsByKey.get(key);
    }

    private static final void setupExplicitSubstitutionsMap() throws Exception {
        JAXBContext substitutionsContext = JAXBContext.newInstance((String)"org.docx4j.fonts.substitutions");
        Unmarshaller u2 = substitutionsContext.createUnmarshaller();
        u2.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        log.info("unmarshalling fonts.substitutions");
        InputStream is2 = null;
        is2 = ResourceUtils.getResource("org/docx4j/fonts/substitutions/FontSubstitutions.xml");
        FontSubstitutions fs = (FontSubstitutions)u2.unmarshal(is2);
        List<FontSubstitutions.Replace> replaceList = fs.getReplace();
        for (FontSubstitutions.Replace replacement : replaceList) {
            explicitSubstitutionsMap.put(replacement.getName(), replacement);
        }
    }

    @Override
    public void populateFontMappings(Set<String> documentFontNames, Fonts wmlFonts) throws Exception {
        List<Fonts.Font> fontList = wmlFonts.getFont();
        HashMap<String, Fonts.Font> fontsInFontTable = new HashMap<String, Fonts.Font>();
        for (Fonts.Font font : fontList) {
            fontsInFontTable.put(font.getName(), font);
        }
        log.info("\n\n Populating font mappings.");
        for (String documentFontName : documentFontNames) {
            PhysicalFont fontMatched = null;
            log.debug("\n\n" + documentFontName);
            if (fontMappings.get(documentFontName) != null) {
                log.info(documentFontName + " already mapped.");
                if (this.lastSeenNumberOfPhysicalFonts == PhysicalFonts.getPhysicalFonts().size()) {
                    log.info(".. and no need to check again.");
                    continue;
                }
                log.info(".. but checking again, since physical fonts have changed.");
            }
            FontPanose wmlFontPanoseForDocumentFont = null;
            Fonts.Font font = (Fonts.Font)fontsInFontTable.get(documentFontName);
            if (font == null) {
                log.error("Font " + documentFontName + "not found in font table!");
            } else {
                wmlFontPanoseForDocumentFont = font.getPanose1();
            }
            Panose documentFontPanose = null;
            if (wmlFontPanoseForDocumentFont != null && wmlFontPanoseForDocumentFont.getVal() != null) {
                try {
                    documentFontPanose = Panose.makeInstance(wmlFontPanoseForDocumentFont.getVal());
                }
                catch (IllegalArgumentException e) {
                    log.error(e.getMessage());
                }
                if (documentFontPanose != null) {
                    log.debug(".. " + documentFontPanose.toString());
                }
            } else {
                log.debug(".. no panose info!!!");
            }
            if (documentFontPanose != null) {
                FontSubstitutions.Replace rtmp;
                String panoseKey;
                if (log.isDebugEnabled() && Panose.validPanose(documentFontPanose.getPanoseArray()) != null) {
                    log.debug(documentFontName + " : " + Panose.validPanose(documentFontPanose.getPanoseArray()));
                }
                if ((panoseKey = this.findClosestPanoseMatch(documentFontName, documentFontPanose, PhysicalFonts.getPhysicalFonts(), 30)) == null) {
                    log.debug(documentFontName + " -->  no panose match");
                    continue;
                }
                fontMatched = PhysicalFonts.getPhysicalFonts().get(panoseKey);
                if (fontMatched != null) {
                    fontMappings.put(documentFontName, PhysicalFonts.getPhysicalFonts().get(panoseKey));
                    log.debug("Mapped " + documentFontName + " -->  " + panoseKey + "( " + PhysicalFonts.getPhysicalFonts().get(panoseKey).getEmbeddedFile());
                } else {
                    log.debug("font with key " + panoseKey + " doesn't exist!");
                }
                if ((rtmp = explicitSubstitutionsMap.get(documentFontName)) == null || rtmp.getSubstFonts() == null) continue;
                if (rtmp.getSubstFonts().contains(panoseKey)) {
                    log.debug("(consistent with explicit substitutes)");
                    continue;
                }
                log.debug("(lucky, since this is missing from explicit substitutes)");
                continue;
            }
            log.debug(" --> null Panose");
            log.debug("So try explicit font substitutions table");
            FontSubstitutions.Replace replacement = explicitSubstitutionsMap.get(BestMatchingMapper.generateFontKey(documentFontName));
            if (replacement != null) {
                String[] tokens = StringUtils.stripAll((String[])replacement.getSubstFonts().split(";"));
                boolean foundMapping = false;
                for (int x = 0; x < tokens.length; ++x) {
                    fontMatched = BestMatchingMapper.getPhysicalFontByKey(tokens[x]);
                    if (fontMatched == null) continue;
                    String physicalFontFile = fontMatched.getEmbeddedFile();
                    log.debug("PDF: " + documentFontName + " --> " + physicalFontFile);
                    foundMapping = true;
                    if (fontMatched.getPanose() == null) {
                        log.debug(".. as expected, lacking Panose");
                        break;
                    }
                    if (documentFontPanose == null) break;
                    Panose physicalFontPanose = null;
                    try {
                        physicalFontPanose = Panose.makeInstance(fontMatched.getPanose().getPanoseArray());
                    }
                    catch (IllegalArgumentException e) {
                        log.error(e.getMessage());
                    }
                    if (physicalFontPanose == null) break;
                    long pd = documentFontPanose.difference(physicalFontPanose, null);
                    if (pd >= 30L) {
                        log.debug(".. with a panose distance exceeding threshold: " + pd);
                        break;
                    }
                    log.error(".. with a low panose distance (! How did we get here?) : " + pd);
                    break;
                }
                if (!foundMapping) {
                    log.debug(documentFontName + " -->  Couldn't find any of " + replacement.getSubstFonts());
                }
            } else {
                log.debug("Nothing in FontSubstitutions.xml for: " + documentFontName);
            }
            if (fontMatched != null) {
                fontMappings.put(documentFontName, fontMatched);
                log.warn("Mapped " + documentFontName + " -->  " + fontMatched.getName() + "( " + fontMatched.getEmbeddedFile());
                continue;
            }
            log.debug("Nothing added for: " + documentFontName);
        }
        this.lastSeenNumberOfPhysicalFonts = PhysicalFonts.getPhysicalFonts().size();
    }

    private PhysicalFont getAssociatedPhysicalFont(String documentFontName, String orignalKey, Panose soughtPanose) {
        log.debug("Looking for " + soughtPanose);
        String resultingPanoseKey = this.findClosestPanoseMatch(documentFontName, soughtPanose, PhysicalFonts.getPhysicalFonts(), 30);
        if (resultingPanoseKey != null) {
            log.info("--> " + PhysicalFonts.getPhysicalFonts().get(resultingPanoseKey).getEmbeddedFile());
            return PhysicalFonts.getPhysicalFonts().get(resultingPanoseKey);
        }
        log.warn("No match in panose space");
        return null;
    }

    private String findClosestPanoseMatch(String documentFontName, Panose documentFontPanose, Map<String, PhysicalFont> physicalFontSpace, int matchThreshold) {
        String keywordToMatch = documentFontName.toLowerCase();
        if (documentFontName.indexOf(" ") > -1) {
            keywordToMatch = keywordToMatch.substring(0, keywordToMatch.indexOf(" "));
        }
        String physicalFontKey = null;
        String panoseKey = null;
        Iterator<Map.Entry<String, PhysicalFont>> it = physicalFontSpace.entrySet().iterator();
        long bestPanoseMatchValue = -1L;
        String matchingPanoseString = null;
        while (it.hasNext()) {
            Map.Entry<String, PhysicalFont> mapPairs = it.next();
            physicalFontKey = mapPairs.getKey();
            PhysicalFont physicalFont = mapPairs.getValue();
            if (physicalFont.getPanose() == null) continue;
            Panose physicalFontPanose = null;
            long panoseMatchValue = 31L;
            try {
                physicalFontPanose = Panose.makeInstance(physicalFont.getPanose().getPanoseArray());
                panoseMatchValue = documentFontPanose.difference(physicalFontPanose, null);
            }
            catch (IllegalArgumentException e) {
                log.error(e.getMessage());
            }
            boolean trump = false;
            if (panoseMatchValue == bestPanoseMatchValue && physicalFont.getName().toLowerCase().indexOf(keywordToMatch) > -1) {
                trump = true;
                log.debug("trumped previous best (which was " + panoseKey + ")");
            }
            if (log.isDebugEnabled() && panoseMatchValue > bestPanoseMatchValue && physicalFont.getName().toLowerCase().indexOf(keywordToMatch) > 0) {
                log.debug("Despite name match, " + physicalFont.getName() + physicalFont.getPanose() + " is too far from " + documentFontPanose + " .. " + panoseMatchValue + " > " + bestPanoseMatchValue);
            }
            if (!trump && bestPanoseMatchValue != -1L && panoseMatchValue >= bestPanoseMatchValue) continue;
            bestPanoseMatchValue = panoseMatchValue;
            matchingPanoseString = physicalFont.getPanose().toString();
            panoseKey = physicalFontKey;
        }
        if (panoseKey != null && bestPanoseMatchValue < (long)matchThreshold) {
            log.debug("MATCHED " + panoseKey + " --> " + matchingPanoseString + " distance " + bestPanoseMatchValue);
            return panoseKey;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String inputfilepath = "/home/dev/workspace/docx4j/sample-docs/Word2007-fonts.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        FontTablePart fontTablePart = wordMLPackage.getMainDocumentPart().getFontTablePart();
        Fonts fonts = (Fonts)fontTablePart.getJaxbElement();
        BestMatchingMapper s = new BestMatchingMapper();
        s.populateFontMappings(wordMLPackage.getMainDocumentPart().fontsInUse(), fonts);
    }

    private static void panoseDebugReportOnPhysicalFonts(Map<String, PhysicalFont> physicalFontMap) {
        Iterator<Map.Entry<String, PhysicalFont>> fontIterator = physicalFontMap.entrySet().iterator();
        while (fontIterator.hasNext()) {
            Map.Entry<String, PhysicalFont> pairs = fontIterator.next();
            if (pairs.getKey() == null) {
                log.info("Skipped null key");
                if (pairs.getValue() != null) {
                    log.error(pairs.getValue().getEmbeddedFile());
                }
                if (fontIterator.hasNext()) {
                    pairs = fontIterator.next();
                } else {
                    return;
                }
            }
            String fontName = pairs.getKey();
            PhysicalFont pf = pairs.getValue();
            Panose fopPanose = pf.getPanose();
            if (fopPanose == null) {
                log.warn(fontName + " .. lacks Panose!");
                continue;
            }
            if (fopPanose == null) continue;
            log.debug(fontName + " .. " + fopPanose);
        }
    }

    static {
        try {
            msFontsFilenames = new HashMap();
            BestMatchingMapper.setupMicrosoftFontFilenames();
            PhysicalFonts.discoverPhysicalFonts();
            physicalFontsByKey = new HashMap<String, PhysicalFont>();
            BestMatchingMapper.generateKeysForPhysicalFonts();
            explicitSubstitutionsMap = new HashMap<String, FontSubstitutions.Replace>();
            BestMatchingMapper.setupExplicitSubstitutionsMap();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }
}

