% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{KO_enrich}
\alias{KO_enrich}
\alias{as.enrich_res}
\title{Perform enrichment analysis}
\usage{
KO_enrich(
  ko_stat,
  padj_threshold = 0.05,
  logFC_threshold = NULL,
  add_mini = NULL,
  p.adjust.method = "BH",
  type = c("pathway", "module")[1],
  feature = "ko",
  modulelist = NULL,
  verbose = TRUE
)

as.enrich_res(gsea_res)
}
\arguments{
\item{ko_stat}{ko_stat dataframe from \code{\link[ReporterScore]{ko.test}}.}

\item{padj_threshold}{p.adjust threshold to determine whether a feature significant or not. p.adjust < padj_threshold, default: 0.05}

\item{logFC_threshold}{logFC threshold to determine whether a feature significant or not. abs(logFC)>logFC_threshold, default: NULL}

\item{add_mini}{add_mini when calculate the logFC. e.g (10+0.1)/(0+0.1), default 0.05*min(avg_abundance)}

\item{p.adjust.method}{The method used for p-value adjustment (default: "BH").}

\item{type}{"pathway" or "module" for default KOlist_file.}

\item{feature}{one of "ko", "gene", "compound"}

\item{modulelist}{NULL or customized modulelist dataframe, must contain "id","K_num","KOs","Description" columns. Take the `KOlist` as example, use \code{\link{custom_modulelist}}.}

\item{verbose}{logical}

\item{gsea_res}{gsea_res from KO_gsea}
}
\value{
A data frame containing the enrichment results.

enrich_res object
}
\description{
This function performs KO enrichment analysis using the `clusterProfiler` package.
}
\seealso{
Other common_enrich: 
\code{\link{KO_fisher}()},
\code{\link{KO_gsa}()},
\code{\link{KO_gsea}()},
\code{\link{KO_gsva}()},
\code{\link{KO_padog}()},
\code{\link{KO_safe}()},
\code{\link{KO_sea}()},
\code{\link{plot_enrich_res}()}
}
\concept{common_enrich}
