% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CORSMiddleware.R
\name{CORSMiddleware}
\alias{CORSMiddleware}
\title{Creates CORS middleware object}
\description{
Adds CORS to \link{Application}. CORS Middleware out of the box in RestRserve to turn on/off the CORS
Headers on preflight validation from the browser. \cr

Cross Origin Resource Sharing is an additional security check done by moderns
browsers to avoid request between different domains. To allow it RestRserve
has easy way to enable your CORS policies. By default CORS policies are disabled.
So if any request is coming from a different domain will be blocked
by the browser as default because RestRserve will not send the headers required
by the browser to allow cross site resource sharing. You can change this easy
just by providing \code{CORSMiddleware} as middleware to the \link{Application}.
}
\examples{
app = Application$new(middleware = list(CORSMiddleware$new()))
app$add_post(path = "/hello", FUN = function(req, res) {
  res$set_body("Hello from RestRserve!")
})
app$add_route("/hello", method = "OPTIONS", FUN = function(req, res) {
 res$set_header("Allow", "POST, OPTIONS")
})
req = Request$new(
  path = "/hello",
  headers = list("Access-Control-Request-Method" = "POST"),
  method = "OPTIONS"
)
app$process_request(req)

}
\references{
\href{https://developer.mozilla.org/en/docs/Web/HTTP/CORS}{MDN}
}
\seealso{
\link{Middleware} \link{Application}
}
\section{Super class}{
\code{\link[RestRserve:Middleware]{RestRserve::Middleware}} -> \code{CORSMiddleware}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{CORSMiddleware$new()}}
\item \href{#method-clone}{\code{CORSMiddleware$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates CORS middleware object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CORSMiddleware$new(routes = "/", match = "partial", id = "CORSMiddleware")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{routes}}{Routes paths to protect.}

\item{\code{match}}{How routes will be matched: exact or partial (as prefix).}

\item{\code{id}}{Middleware id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CORSMiddleware$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
