% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_uncertainty.R
\docType{methods}
\name{rc_unc}
\alias{rc_unc}
\title{Uncertainty of the Return Curve estimates}
\usage{
rc_unc(retcurve, blocksize = 1, nboot = 250, nangles = 150, alpha = 0.05)
}
\arguments{
\item{retcurve}{An S4 object of class \code{rc_est.class}. See \code{\link{rc_est}} for more details.}

\item{blocksize}{Size of the blocks for the block bootstrap procedure. If \code{1} (default), then a standard bootstrap approach is applied.}

\item{nboot}{Number of bootstrap samples to be taken. Default is \code{250} samples.}

\item{nangles}{\loadmathjax{} Number of angles \mjeqn{m}{m} in the interval \mjeqn{(0, \pi/2)}{} \insertCite{MurphyBarltropetal2023}{ReturnCurves}. Default is \code{150} angles.}

\item{alpha}{Significance level to compute the \mjeqn{(1-\alpha)}{}\% confidence intervals. Default is \code{0.05}.}
}
\value{
An object of S4 class \code{rc_unc.class}. This object returns the arguments of the function and an extra slot \code{unc} which is a list containing:
\item{median}{A vector containing the median estimates of the return curve.} 
\item{mean}{A vector containing the mean estimates of the return curve.} 
\item{lower}{A vector containing the lower bound of the confidence interval.}
\item{upper}{A vector containing the upper bound of the confidence interval.}

The \code{plot} function takes an object of S4 class \code{rc_unc.class}, and a \code{which} argument specifying the type of plot desired (see \strong{Examples}):
\item{\code{"rc"}}{Plots the estimated Return Curve and its uncertainty (default).}
\item{\code{"median"}}{Plots the median estimates of the Return Curve and its uncertainty.}
\item{\code{"mean"}}{Plots the mean estimates of the Return Curve and its uncertainty.}
\item{\code{"all"}}{Plots the estimated Return Curve, the median and mean estimates of the Return Curve together, and the associated uncertainty.}
}
\description{
Uncertainty assessment of the return curve estimates following the procedure of \insertCite{MurphyBarltropetal2023;textual}{ReturnCurves}.
}
\details{
Define a set of angles \mjdeqn{\boldsymbol{\Theta}:= \left\lbrace \frac{\pi(m+1-j)}{2(m+1)} \mid 1\leq j\leq m\right\rbrace}{} decreasing from near \mjeqn{\pi/2}{} to \mjeqn{0}{0}, 
and let \mjeqn{L_\theta:=\left\lbrace(x,y)\in R^2_+ | \tan(\theta)=y/x\right\rbrace}{} denote the line segment intersecting the origin with gradient \mjeqn{\tan(\theta) > 0.}{}
For each \mjeqn{\theta\in \boldsymbol{\Theta},}{} \mjeqn{L_\theta}{} intersects the estimated \mjeqn{\hat{RC}(p)}{} exactly once, i.e. \mjeqn{\lbrace(\hat{x}_\theta, \hat{y}_\theta)\rbrace:= \hat{RC}(p)\cap L_\theta.}{} 
Uncertainty of the return curve is then quantified by the distribution of \mjeqn{\hat{d}_\theta:=(\hat{x}^2_\theta + \hat{y}^2_\theta)^{1/2}}{} via a (block) bootstrap procedure. 

This procedure is as follows; for \mjeqn{k = 1, \ldots, }{} \code{nboot}:

1. (Block) bootstrap the original data set; 

2. For each \mjeqn{\theta\in \boldsymbol{\Theta},}{} obtain \mjeqn{\hat{d}_{\theta,k}}{} for the corresponding return curve point estimate.

Full details can be found in \insertCite{MurphyBarltropetal2023;textual}{ReturnCurves}
}
\examples{
library(ReturnCurves)

data(airdata)

n <- dim(airdata)[1]

prob <- 10/n

margdata <- margtransf(airdata)

rc_orig <- rc_est(margdata = margdata, p = prob, method = "hill")

\donttest{
# Set nboot = 50 for an illustrative example
# blocksize to account for temporal dependence
unc <- rc_unc(rc_orig, blocksize = 10) 

# Plots the estimated Return Curve 
plot(unc, which = "rc") 

# Plots the median estimates of the Return Curve
plot(unc, which = "median") 

# Plots the mean estimates of the Return Curve
plot(unc, which = "mean") 

# Plots the estimated Return Curve and its the median and mean estimates
plot(unc, which = "all") 

# To see the the S4 object's slots
str(unc)

# To access the list of vectors
unc@unc
}

}
\references{
\insertAllCited{}
}
