% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateCooperationIndex.R
\name{calculateCooperationIndex}
\alias{calculateCooperationIndex}
\title{Calculating the metabolic competition and complementarity index}
\usage{
calculateCooperationIndex(g, ..., threshold = 0, p = FALSE, nperm = 1000)
}
\arguments{
\item{g, }{igraph that represents a metabolic network, see \code{\link{reconstructGsMN}}}

\item{..., }{a list of metabolic networks or a network append to g}

\item{threshold}{threshold, the cutoff of confidence score to be serve as a 
seed set, default is 0.2}

\item{p, }{a logical value which determins whether the calculated index is 
statistical or biological significant. default is FALSE}

\item{nperm, }{the number of permuations of metabolic network node labes, which
is used for p value calculation, default is 1000.}
}
\value{
a cooperation index matrix whose nrow and ncol is equal to the number 
of species to be compared, for more see details.
}
\description{
Calculating the metabolic competition complementarity index among all metabolic 
networks
}
\details{
Metabolic competition index is defined as the fraction of compounds 
in a species seed set of metabolic network that are alse included in its 
partner; However, metabolic complementarity index is the fraction of 
compounds in one species seed set of metabolic network appearing in the 
metabolic network but not in the seed set of its partner; The biosynthetic 
support score represents the extent to which the metabolic requirements of a 
potential parasitic organism can be supported by the biosynthetic capacity of
a potential host. It is measured by calculating the fraction of the source 
components of a, in which at least one of the compounds can be found in the 
network of b. However, seed compounds are associated with a confidence score 
(1/size of SCC), so this fraction is calculated as a mormalized weighted sum. 

The ith row and jth col elements of the returnd matrix represents the 
metabolic competition index or complementarity index of the ith network on the
jth metabolic network.
}
\examples{
\dontrun{
## metabolic network reconstruction and seed set identity of sample data anno.species
net <- lapply(anno.species,reconstructGsMN)
interactions <- calculateCooperationIndex(net)
}
}
\seealso{
\code{\link{complementarityIndex}},
\code{\link{competitionIndex}}
}

