% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottree.R
\name{plot-forestry}
\alias{plot-forestry}
\alias{plot.forestry}
\title{visualize a tree}
\usage{
\method{plot}{forestry}(x, tree.id = 1, print.meta_dta = FALSE, beta.char.len = 30, ...)
}
\arguments{
\item{x}{A forestry x.}

\item{tree.id}{Specifies the tree number that should be visualized.}

\item{print.meta_dta}{A flag indicating whether the data for the plot should be printed.}

\item{beta.char.len}{The length of the beta values in leaf node
representation. This is only required when plotting a forestry object with linear
aggregation functions (linear = TRUE).}

\item{...}{additional arguments that are not used.}
}
\value{
A plot of the specified tree in the forest.
}
\description{
plots a tree in the forest.
}
\examples{
set.seed(292315)
rf <- forestry(x = iris[,-1],
               y = iris[, 1],
               nthread = 2)

plot(x = rf)
plot(x = rf, tree.id = 2)
plot(x = rf, tree.id = 500)

ridge_rf <- forestry(
  x = iris[,-1],
  y = iris[, 1],
  replace = FALSE,
  nodesizeStrictSpl = 10,
  mtry = 4,
  ntree = 1000,
  minSplitGain = .004,
  linear = TRUE,
  nthread = 2,
  overfitPenalty = 1.65,
  linFeats = 1:2)

plot(x = ridge_rf)
plot(x = ridge_rf, tree.id = 2)
plot(x = ridge_rf, tree.id = 1000)

}
