% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Montana.R
\name{Montana}
\alias{Montana}
\title{Montana Intraday Temperature Curves and NDVI Images Data Set}
\description{
This dataset includes intraday hourly temperature curves measured in degrees Celsius and normalized difference vegetation index (NDVI) image data. The observations were recorded near Saint Mary, Montana, USA. The NDVI images cover a geographical region with longitudes ranging from 113.30 degrees West to 113.56 degrees West and latitudes from 48.71 degrees North to 48.78 degrees North.
The intraday temperature curves are sourced from Diamond et al. (2013), while the NDVI images were obtained from resources provided by Tuck et al. (2014).
For each recorded intraday temperature curve, an NDVI image was captured on the same day every 16 days. Data collection started on January 1, 2008, and concluded on September 30, 2013.
The primary goal of this dataset is to facilitate the analysis of temperature trends and investigate how temperature changes impact vegetation in the region. A multivariate analysis leveraging both temperature and NDVI variables can reveal more informative patterns and yield stronger signal extraction results.
The dataset is hosted on GitHub, and you can load it using the function \code{\link{loadMontanaData}}.
The dataset has been converted into a multivariate functional time series using two B-spline basis function systems with 11 and 13 members, respectively. The resulting dataset is stored as a functional time series object of class `funts`.
You can load the raw data using the function \code{\link{loadMontanaData}}.
See \code{\link{funts}} for more details.
}
\references{
\enumerate{
  \item Diamond, H. J., Karl, T., Palecki, M. A., Baker, C. B., Bell, J. E., Leeper, R. D., Easterling, D. R., Lawrimore, J. H., Meyers, T. P., Helfert, M. R., Goodge, G., and Thorne, P.W. (2013). U.S. climate reference network after one decade of operations: status and assessment. [Link](https://www.ncdc.noaa.gov/crn/qcdatasets.html). Last accessed April 2020.
  \item Tuck, S. L., Phillips, H. R., Hintzen, R. E., Scharlemann, J. P., Purvis, A., and Hudson, L. N. (2014). MODISTools – downloading and processing MODIS remotely sensed data in R. Ecology and Evolution, 4(24), 4658–4668.
}
}
\seealso{
\code{\link{loadMontanaData}} - Function to load the Montana dataset.
}
