% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_reference_sets}
\alias{search_reference_sets}
\title{Search for Reference Sets}
\usage{
search_reference_sets(client, assembly_id = NULL, accession = NULL,
  md5checksum = NULL, page_size = NULL, page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{assembly_id}{Return the Reference Sets for which the assembly_id matches this string (case-sensitive, exact match).}

\item{accession}{Return the Reference Sets for which the accession matches this string (case-sensitive, exact match).}

\item{md5checksum}{Return the Reference Sets for which the md5checksum matches this string (case-sensitive, exact match).}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for Reference Sets
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{
library(magrittr)
## Search for reference sets
reference_sets <- ref_client \%>\% search_reference_sets() \%>\% content()
reference_sets
}
}

